/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.context;

import java.util.Properties;
import lombok.Generated;
import org.apache.commons.lang3.concurrent.ConcurrentException;
import org.apache.shardingsphere.data.pipeline.core.context.PipelineProcessContext;
import org.apache.shardingsphere.data.pipeline.core.execute.PipelineExecuteEngine;
import org.apache.shardingsphere.data.pipeline.core.job.progress.config.PipelineProcessConfiguration;
import org.apache.shardingsphere.data.pipeline.core.job.progress.config.PipelineProcessConfigurationUtils;
import org.apache.shardingsphere.data.pipeline.core.job.progress.config.PipelineReadConfiguration;
import org.apache.shardingsphere.data.pipeline.core.job.progress.config.PipelineWriteConfiguration;
import org.apache.shardingsphere.data.pipeline.core.ratelimit.JobRateLimitAlgorithm;
import org.apache.shardingsphere.data.pipeline.core.util.PipelineLazyInitializer;
import org.apache.shardingsphere.infra.algorithm.core.config.AlgorithmConfiguration;
import org.apache.shardingsphere.infra.spi.type.typed.TypedSPILoader;

public final class TransmissionProcessContext
implements PipelineProcessContext {
    private final PipelineProcessConfiguration processConfiguration;
    private final JobRateLimitAlgorithm readRateLimitAlgorithm;
    private final JobRateLimitAlgorithm writeRateLimitAlgorithm;
    private final PipelineLazyInitializer<PipelineExecuteEngine> inventoryDumperExecuteEngineLazyInitializer;
    private final PipelineLazyInitializer<PipelineExecuteEngine> inventoryImporterExecuteEngineLazyInitializer;
    private final PipelineLazyInitializer<PipelineExecuteEngine> incrementalExecuteEngineLazyInitializer;

    public TransmissionProcessContext(final String jobId, PipelineProcessConfiguration originalProcessConfig) {
        this.processConfiguration = PipelineProcessConfigurationUtils.fillInDefaultValue(originalProcessConfig);
        final PipelineReadConfiguration readConfig = this.processConfiguration.getRead();
        AlgorithmConfiguration readRateLimiter = readConfig.getRateLimiter();
        this.readRateLimitAlgorithm = null == readRateLimiter ? null : (JobRateLimitAlgorithm)TypedSPILoader.getService(JobRateLimitAlgorithm.class, (Object)readRateLimiter.getType(), (Properties)readRateLimiter.getProps());
        final PipelineWriteConfiguration writeConfig = this.processConfiguration.getWrite();
        AlgorithmConfiguration writeRateLimiter = writeConfig.getRateLimiter();
        this.writeRateLimitAlgorithm = null == writeRateLimiter ? null : (JobRateLimitAlgorithm)TypedSPILoader.getService(JobRateLimitAlgorithm.class, (Object)writeRateLimiter.getType(), (Properties)writeRateLimiter.getProps());
        this.inventoryDumperExecuteEngineLazyInitializer = new PipelineLazyInitializer<PipelineExecuteEngine>(){

            @Override
            protected PipelineExecuteEngine doInitialize() {
                return PipelineExecuteEngine.newFixedThreadInstance(readConfig.getWorkerThread(), "Inventory-" + jobId);
            }
        };
        this.inventoryImporterExecuteEngineLazyInitializer = new PipelineLazyInitializer<PipelineExecuteEngine>(){

            @Override
            protected PipelineExecuteEngine doInitialize() {
                return PipelineExecuteEngine.newFixedThreadInstance(writeConfig.getWorkerThread(), "Importer-" + jobId);
            }
        };
        this.incrementalExecuteEngineLazyInitializer = new PipelineLazyInitializer<PipelineExecuteEngine>(){

            @Override
            protected PipelineExecuteEngine doInitialize() {
                return PipelineExecuteEngine.newCachedThreadInstance("Incremental-" + jobId);
            }
        };
    }

    public PipelineExecuteEngine getInventoryDumperExecuteEngine() {
        return (PipelineExecuteEngine)this.inventoryDumperExecuteEngineLazyInitializer.get();
    }

    public PipelineExecuteEngine getInventoryImporterExecuteEngine() {
        return (PipelineExecuteEngine)this.inventoryImporterExecuteEngineLazyInitializer.get();
    }

    public PipelineExecuteEngine getIncrementalExecuteEngine() {
        return (PipelineExecuteEngine)this.incrementalExecuteEngineLazyInitializer.get();
    }

    @Override
    public void close() throws Exception {
        this.shutdownExecuteEngine(this.inventoryDumperExecuteEngineLazyInitializer);
        this.shutdownExecuteEngine(this.inventoryImporterExecuteEngineLazyInitializer);
        this.shutdownExecuteEngine(this.incrementalExecuteEngineLazyInitializer);
    }

    private void shutdownExecuteEngine(PipelineLazyInitializer<PipelineExecuteEngine> lazyInitializer) throws ConcurrentException {
        if (lazyInitializer.isInitialized()) {
            ((PipelineExecuteEngine)lazyInitializer.get()).shutdown();
        }
    }

    @Override
    @Generated
    public PipelineProcessConfiguration getProcessConfiguration() {
        return this.processConfiguration;
    }

    @Generated
    public JobRateLimitAlgorithm getReadRateLimitAlgorithm() {
        return this.readRateLimitAlgorithm;
    }

    @Generated
    public JobRateLimitAlgorithm getWriteRateLimitAlgorithm() {
        return this.writeRateLimitAlgorithm;
    }
}

