/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.distsql.handler.transmission.update;

import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.core.job.progress.config.PipelineProcessConfiguration;
import org.apache.shardingsphere.data.pipeline.core.job.progress.config.PipelineReadConfiguration;
import org.apache.shardingsphere.data.pipeline.core.job.progress.config.PipelineWriteConfiguration;
import org.apache.shardingsphere.distsql.segment.AlgorithmSegment;
import org.apache.shardingsphere.distsql.segment.ReadOrWriteSegment;
import org.apache.shardingsphere.distsql.segment.TransmissionRuleSegment;
import org.apache.shardingsphere.infra.algorithm.core.config.AlgorithmConfiguration;

public final class TransmissionProcessConfigurationSegmentConverter {
    public static PipelineProcessConfiguration convert(TransmissionRuleSegment segment) {
        PipelineReadConfiguration readConfig = TransmissionProcessConfigurationSegmentConverter.convertToReadConfiguration(segment.getReadSegment());
        PipelineWriteConfiguration writeConfig = TransmissionProcessConfigurationSegmentConverter.convertToWriteConfiguration(segment.getWriteSegment());
        AlgorithmConfiguration streamChannel = TransmissionProcessConfigurationSegmentConverter.convertToAlgorithm(segment.getStreamChannel());
        return new PipelineProcessConfiguration(readConfig, writeConfig, streamChannel);
    }

    private static PipelineReadConfiguration convertToReadConfiguration(ReadOrWriteSegment readSegment) {
        return null == readSegment ? null : new PipelineReadConfiguration(readSegment.getWorkerThread(), readSegment.getBatchSize(), readSegment.getShardingSize(), TransmissionProcessConfigurationSegmentConverter.convertToAlgorithm(readSegment.getRateLimiter()));
    }

    private static PipelineWriteConfiguration convertToWriteConfiguration(ReadOrWriteSegment writeSegment) {
        return null == writeSegment ? null : new PipelineWriteConfiguration(writeSegment.getWorkerThread(), writeSegment.getBatchSize(), TransmissionProcessConfigurationSegmentConverter.convertToAlgorithm(writeSegment.getRateLimiter()));
    }

    private static AlgorithmConfiguration convertToAlgorithm(AlgorithmSegment segment) {
        return null == segment ? null : new AlgorithmConfiguration(segment.getName(), segment.getProps());
    }

    @Generated
    private TransmissionProcessConfigurationSegmentConverter() {
    }
}

