/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.agent.core.advisor.config.yaml.swapper;

import java.util.LinkedList;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import lombok.Generated;
import org.apache.shardingsphere.agent.core.advisor.config.yaml.entity.YamlPointcutConfiguration;
import org.apache.shardingsphere.agent.core.advisor.config.yaml.entity.YamlPointcutParameterConfiguration;
import org.apache.shardingsphere.shade.net.bytebuddy.description.method.MethodDescription;
import org.apache.shardingsphere.shade.net.bytebuddy.matcher.ElementMatcher;
import org.apache.shardingsphere.shade.net.bytebuddy.matcher.ElementMatchers;
import org.apache.shardingsphere.shade.net.bytebuddy.matcher.ModifierMatcher;

public final class YamlPointcutConfigurationSwapper {
    private static final Logger LOGGER = Logger.getLogger(YamlPointcutConfigurationSwapper.class.getName());

    public static Optional<ElementMatcher<MethodDescription>> swap(YamlPointcutConfiguration yamlConfig) {
        if ("constructor".equals(yamlConfig.getType())) {
            return Optional.of(YamlPointcutConfigurationSwapper.createElementMatcher(yamlConfig, ElementMatchers.isConstructor()));
        }
        if ("method".equals(yamlConfig.getType())) {
            return Optional.of(YamlPointcutConfigurationSwapper.createElementMatcher(yamlConfig, ElementMatchers.named(yamlConfig.getName())));
        }
        return Optional.empty();
    }

    private static ElementMatcher<MethodDescription> createElementMatcher(YamlPointcutConfiguration yamlConfig, ElementMatcher.Junction<MethodDescription> pointcut) {
        ElementMatcher.Junction<MethodDescription> result = YamlPointcutConfigurationSwapper.appendMethodModifiers(yamlConfig.getModifiers(), pointcut);
        result = YamlPointcutConfigurationSwapper.appendParameters(yamlConfig, result);
        return YamlPointcutConfigurationSwapper.appendReturns(yamlConfig, result);
    }

    private static ElementMatcher.Junction<MethodDescription> appendMethodModifiers(String methodModifiers, ElementMatcher.Junction<MethodDescription> pointcut) {
        String[] modifiers;
        ElementMatcher.Junction<MethodDescription> result = pointcut;
        if (null == methodModifiers) {
            return result;
        }
        for (String each : modifiers = methodModifiers.split("\\s")) {
            Optional<ModifierMatcher.Mode> mode = YamlPointcutConfigurationSwapper.findMode(each.trim().toUpperCase());
            if (!mode.isPresent()) continue;
            result = result.and(ModifierMatcher.of(mode.get()));
        }
        return result;
    }

    private static Optional<ModifierMatcher.Mode> findMode(String mode) {
        try {
            return Optional.of(ModifierMatcher.Mode.valueOf(mode.toUpperCase()));
        }
        catch (IllegalArgumentException ignored) {
            LOGGER.log(Level.SEVERE, "Invalid parameters `{0}`, valid values is [{1}]", new String[]{mode, YamlPointcutConfigurationSwapper.getValidValues()});
            return Optional.empty();
        }
    }

    private static String getValidValues() {
        LinkedList<String> result = new LinkedList<String>();
        for (ModifierMatcher.Mode each : ModifierMatcher.Mode.values()) {
            result.add(each.name().toLowerCase());
        }
        return String.join((CharSequence)",", result);
    }

    private static ElementMatcher.Junction<MethodDescription> appendParameters(YamlPointcutConfiguration yamlConfig, ElementMatcher.Junction<MethodDescription> pointcut) {
        ElementMatcher.Junction<MethodDescription> result = pointcut;
        if (null != yamlConfig.getParamLength() && 0 <= yamlConfig.getParamLength()) {
            result = result.and(ElementMatchers.takesArguments(yamlConfig.getParamLength()));
        }
        for (YamlPointcutParameterConfiguration each : yamlConfig.getParams()) {
            result = result.and(ElementMatchers.takesArgument(each.getIndex(), ElementMatchers.named(each.getType())));
        }
        return result;
    }

    private static ElementMatcher.Junction<MethodDescription> appendReturns(YamlPointcutConfiguration yamlConfig, ElementMatcher.Junction<MethodDescription> pointcut) {
        ElementMatcher.Junction<MethodDescription> result = pointcut;
        if (null == yamlConfig.getReturnType()) {
            return result;
        }
        result = result.and(ElementMatchers.returns(ElementMatchers.named(yamlConfig.getReturnType())));
        return result;
    }

    @Generated
    private YamlPointcutConfigurationSwapper() {
    }
}

