/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.rewrite.sql.token.common.pojo.generic;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import lombok.Generated;
import org.apache.shardingsphere.infra.database.core.metadata.database.enums.QuoteCharacter;
import org.apache.shardingsphere.infra.rewrite.sql.token.common.pojo.Attachable;
import org.apache.shardingsphere.infra.rewrite.sql.token.common.pojo.SQLToken;

public final class UseDefaultInsertColumnsToken
extends SQLToken
implements Attachable {
    private final List<String> columns;
    private final QuoteCharacter quoteCharacter;

    public UseDefaultInsertColumnsToken(int startIndex, List<String> columns) {
        super(startIndex);
        this.columns = columns;
        this.quoteCharacter = QuoteCharacter.NONE;
    }

    public UseDefaultInsertColumnsToken(int startIndex, List<String> columns, QuoteCharacter quoteCharacter) {
        super(startIndex);
        this.columns = columns;
        this.quoteCharacter = quoteCharacter;
    }

    public String toString() {
        return this.columns.isEmpty() ? "" : "(" + String.join((CharSequence)", ", this.getColumnNames()) + ")";
    }

    private Collection<String> getColumnNames() {
        ArrayList<String> result = new ArrayList<String>(this.columns.size());
        for (String each : this.columns) {
            result.add(this.quoteCharacter.wrap(each));
        }
        return result;
    }

    @Override
    public int getStopIndex() {
        return this.getStartIndex();
    }

    @Generated
    public List<String> getColumns() {
        return this.columns;
    }

    @Generated
    public QuoteCharacter getQuoteCharacter() {
        return this.quoteCharacter;
    }
}

