/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.opengauss.sqlbuilder;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.apache.shardingsphere.data.pipeline.core.exception.job.CreateTableSQLGenerateException;
import org.apache.shardingsphere.data.pipeline.core.ingest.record.DataRecord;
import org.apache.shardingsphere.data.pipeline.core.sqlbuilder.dialect.DialectPipelineSQLBuilder;
import org.apache.shardingsphere.data.pipeline.core.sqlbuilder.segment.PipelineSQLSegmentBuilder;

public final class OpenGaussPipelineSQLBuilder
implements DialectPipelineSQLBuilder {
    public Optional<String> buildCreateSchemaSQL(String schemaName) {
        return Optional.of(String.format("CREATE SCHEMA %s", schemaName));
    }

    public Optional<String> buildInsertOnDuplicateClause(DataRecord dataRecord) {
        StringBuilder result = new StringBuilder("ON DUPLICATE KEY UPDATE ");
        PipelineSQLSegmentBuilder sqlSegmentBuilder = new PipelineSQLSegmentBuilder(this.getType());
        result.append(dataRecord.getColumns().stream().filter(each -> !each.isUniqueKey()).map(each -> sqlSegmentBuilder.getEscapedIdentifier(each.getName()) + "=EXCLUDED." + sqlSegmentBuilder.getEscapedIdentifier(each.getName())).collect(Collectors.joining(",")));
        return Optional.of(result.toString());
    }

    public String buildCheckEmptyTableSQL(String qualifiedTableName) {
        return String.format("SELECT * FROM %s LIMIT 1", qualifiedTableName);
    }

    public Optional<String> buildEstimatedCountSQL(String catalogName, String qualifiedTableName) {
        return Optional.of(String.format("SELECT reltuples::integer FROM pg_class WHERE oid='%s'::regclass::oid;", qualifiedTableName));
    }

    public Collection<String> buildCreateTableSQLs(DataSource dataSource, String schemaName, String tableName) throws SQLException {
        try (Connection connection = dataSource.getConnection();
             Statement statement = connection.createStatement();
             ResultSet resultSet = statement.executeQuery(String.format("SELECT * FROM pg_get_tabledef('%s.%s')", schemaName, tableName));){
            if (resultSet.next()) {
                List<String> defSQLs = Arrays.asList(resultSet.getString("pg_get_tabledef").split(";"));
                Collection collection = defSQLs.stream().map(sql -> {
                    String targetPrefix = "ALTER TABLE " + tableName;
                    if (sql.trim().startsWith(targetPrefix)) {
                        return sql.replaceFirst(targetPrefix, "ALTER TABLE " + schemaName + "." + tableName);
                    }
                    return sql;
                }).collect(Collectors.toList());
                return collection;
            }
        }
        throw new CreateTableSQLGenerateException(tableName);
    }

    public Optional<String> buildQueryCurrentPositionSQL() {
        return Optional.of("SELECT * FROM pg_current_xlog_location()");
    }

    public String wrapWithPageQuery(String sql) {
        return sql + " LIMIT ?";
    }

    public String getDatabaseType() {
        return "openGauss";
    }
}

