/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.shardingsphere.encrypt.rule.column;

import lombok.Getter;
import lombok.RequiredArgsConstructor;
import lombok.Setter;
import org.apache.shardingsphere.encrypt.rule.column.item.AssistedQueryColumnItem;
import org.apache.shardingsphere.encrypt.rule.column.item.CipherColumnItem;
import org.apache.shardingsphere.encrypt.rule.column.item.LikeQueryColumnItem;
import org.apache.shardingsphere.encrypt.spi.EncryptAlgorithm;

import java.util.Optional;

/**
 * Encrypt column.
 */
@RequiredArgsConstructor
@Getter
@Setter
public final class EncryptColumn {
    
    private final String name;
    
    private final CipherColumnItem cipher;
    
    private AssistedQueryColumnItem assistedQuery;
    
    private LikeQueryColumnItem likeQuery;
    
    /**
     * Get assisted query column item.
     *
     * @return assisted query column item
     */
    public Optional<AssistedQueryColumnItem> getAssistedQuery() {
        return Optional.ofNullable(assistedQuery);
    }
    
    /**
     * Get like query column item.
     *
     * @return like query column item
     */
    public Optional<LikeQueryColumnItem> getLikeQuery() {
        return Optional.ofNullable(likeQuery);
    }
    
    /**
     * Get query encryptor.
     *
     * @return query encryptor
     */
    public EncryptAlgorithm getQueryEncryptor() {
        return null == assistedQuery ? cipher.getEncryptor() : assistedQuery.getEncryptor();
    }
}
