/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.restful.deserializer.impl;

import io.netty.handler.codec.http.HttpHeaderValues;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import org.apache.shardingsphere.elasticjob.restful.deserializer.RequestBodyDeserializer;

public final class DefaultTextPlainRequestBodyDeserializer
implements RequestBodyDeserializer {
    @Override
    public String mimeType() {
        return HttpHeaderValues.TEXT_PLAIN.toString();
    }

    @Override
    public <T> T deserialize(Class<T> targetType, byte[] requestBodyBytes) {
        if (byte[].class.equals(targetType)) {
            return (T)requestBodyBytes;
        }
        if (String.class.isAssignableFrom(targetType)) {
            return (T)new String(requestBodyBytes, StandardCharsets.UTF_8);
        }
        throw new UnsupportedOperationException(MessageFormat.format("Cannot deserialize [{0}] into [{1}]", this.mimeType(), targetType.getName()));
    }
}

