/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.restful.handler;

import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.shardingsphere.elasticjob.restful.handler.Handler;
import org.apache.shardingsphere.elasticjob.restful.mapping.MappingContext;
import org.apache.shardingsphere.elasticjob.restful.mapping.RegexUrlPatternMap;
import org.apache.shardingsphere.elasticjob.restful.mapping.UrlPatternMap;

public final class HandlerMappingRegistry {
    private final Map<HttpMethod, UrlPatternMap<Handler>> mappings = new HashMap<HttpMethod, UrlPatternMap<Handler>>();

    public Optional<MappingContext<Handler>> getMappingContext(HttpRequest httpRequest) {
        String uriWithoutQuery = httpRequest.uri().split("\\?")[0];
        return Optional.ofNullable(this.mappings.get(httpRequest.method())).map(urlPatternMap -> urlPatternMap.match(uriWithoutQuery));
    }

    public void addMapping(HttpMethod method, String pathPattern, Handler handler) {
        UrlPatternMap urlPatternMap = this.mappings.computeIfAbsent(method, httpMethod -> new RegexUrlPatternMap());
        urlPatternMap.put(pathPattern, handler);
    }
}

