/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.restful.serializer.impl;

import com.google.gson.Gson;
import io.netty.handler.codec.http.HttpHeaderValues;
import java.nio.charset.StandardCharsets;
import org.apache.shardingsphere.elasticjob.infra.json.GsonFactory;
import org.apache.shardingsphere.elasticjob.restful.serializer.ResponseBodySerializer;

public final class DefaultJsonResponseBodySerializer
implements ResponseBodySerializer {
    private final Gson gson = GsonFactory.getGson();

    @Override
    public String mimeType() {
        return HttpHeaderValues.APPLICATION_JSON.toString();
    }

    @Override
    public byte[] serialize(Object responseBody) {
        if (responseBody instanceof String) {
            return ((String)responseBody).getBytes(StandardCharsets.UTF_8);
        }
        return this.gson.toJson(responseBody).getBytes(StandardCharsets.UTF_8);
    }
}

