/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.cloud.console.security;

import com.google.common.base.Strings;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import org.apache.commons.codec.binary.Base64;
import org.apache.shardingsphere.elasticjob.cloud.console.security.AuthenticationInfo;
import org.apache.shardingsphere.elasticjob.cloud.scheduler.env.AuthConfiguration;
import org.apache.shardingsphere.elasticjob.cloud.scheduler.env.BootstrapEnvironment;

public final class AuthenticationService {
    private final Gson gson = new GsonBuilder().disableHtmlEscaping().create();
    private final Base64 base64 = new Base64();
    private final BootstrapEnvironment env = BootstrapEnvironment.getINSTANCE();

    public boolean check(AuthenticationInfo authenticationInfo) {
        if (null == authenticationInfo || Strings.isNullOrEmpty((String)authenticationInfo.getUsername()) || Strings.isNullOrEmpty((String)authenticationInfo.getPassword())) {
            return false;
        }
        AuthConfiguration userAuthConfiguration = this.env.getUserAuthConfiguration();
        return userAuthConfiguration.getAuthUsername().equals(authenticationInfo.getUsername()) && userAuthConfiguration.getAuthPassword().equals(authenticationInfo.getPassword());
    }

    public String getToken() {
        return this.base64.encodeToString(this.gson.toJson((Object)this.env.getUserAuthConfiguration()).getBytes());
    }
}

