/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.cloud.scheduler.env;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Optional;
import java.util.Properties;
import lombok.Generated;
import org.apache.commons.dbcp2.BasicDataSource;
import org.apache.shardingsphere.elasticjob.cloud.scheduler.env.AuthConfiguration;
import org.apache.shardingsphere.elasticjob.cloud.scheduler.env.FrameworkConfiguration;
import org.apache.shardingsphere.elasticjob.cloud.scheduler.env.MesosConfiguration;
import org.apache.shardingsphere.elasticjob.cloud.scheduler.env.RestfulServerConfiguration;
import org.apache.shardingsphere.elasticjob.reg.zookeeper.ZookeeperConfiguration;
import org.apache.shardingsphere.elasticjob.tracing.api.TracingConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BootstrapEnvironment {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BootstrapEnvironment.class);
    private static final BootstrapEnvironment INSTANCE = new BootstrapEnvironment();
    private static final String PROPERTIES_PATH = "conf/elasticjob-cloud-scheduler.properties";
    private final Properties properties = this.getProperties();

    private BootstrapEnvironment() {
    }

    private Properties getProperties() {
        Properties result = new Properties();
        try (InputStream fileInputStream = BootstrapEnvironment.class.getClassLoader().getResourceAsStream(PROPERTIES_PATH);){
            result.load(fileInputStream);
        }
        catch (IOException ex) {
            log.warn("Can not load properties file from path: '{}'.", (Object)PROPERTIES_PATH);
        }
        this.setPropertiesByEnv(result);
        return result;
    }

    private void setPropertiesByEnv(Properties prop) {
        for (EnvironmentArgument each : EnvironmentArgument.values()) {
            String key = each.getKey();
            String value = System.getenv(key);
            if (Strings.isNullOrEmpty((String)value)) continue;
            log.info("Load property {} with value {} from ENV.", (Object)key, (Object)value);
            prop.setProperty(each.getKey(), value);
        }
    }

    public String getFrameworkHostPort() {
        return String.format("%s:%d", this.getMesosConfiguration().getHostname(), this.getRestfulServerConfiguration().getPort());
    }

    public MesosConfiguration getMesosConfiguration() {
        return new MesosConfiguration(this.getValue(EnvironmentArgument.USER), this.getValue(EnvironmentArgument.MESOS_URL), this.getValue(EnvironmentArgument.HOSTNAME));
    }

    public ZookeeperConfiguration getZookeeperConfiguration() {
        ZookeeperConfiguration result = new ZookeeperConfiguration(this.getValue(EnvironmentArgument.ZOOKEEPER_SERVERS), this.getValue(EnvironmentArgument.ZOOKEEPER_NAMESPACE));
        String digest = this.getValue(EnvironmentArgument.ZOOKEEPER_DIGEST);
        if (!Strings.isNullOrEmpty((String)digest)) {
            result.setDigest(digest);
        }
        return result;
    }

    public RestfulServerConfiguration getRestfulServerConfiguration() {
        return new RestfulServerConfiguration(Integer.parseInt(this.getValue(EnvironmentArgument.PORT)));
    }

    public FrameworkConfiguration getFrameworkConfiguration() {
        return new FrameworkConfiguration(Integer.parseInt(this.getValue(EnvironmentArgument.JOB_STATE_QUEUE_SIZE)), Integer.parseInt(this.getValue(EnvironmentArgument.RECONCILE_INTERVAL_MINUTES)));
    }

    public AuthConfiguration getUserAuthConfiguration() {
        return new AuthConfiguration(this.getValue(EnvironmentArgument.AUTH_USERNAME), this.getValue(EnvironmentArgument.AUTH_PASSWORD));
    }

    public Optional<TracingConfiguration<?>> getTracingConfiguration() {
        String driver = this.getValue(EnvironmentArgument.EVENT_TRACE_RDB_DRIVER);
        String url = this.getValue(EnvironmentArgument.EVENT_TRACE_RDB_URL);
        String username = this.getValue(EnvironmentArgument.EVENT_TRACE_RDB_USERNAME);
        String password = this.getValue(EnvironmentArgument.EVENT_TRACE_RDB_PASSWORD);
        if (!(Strings.isNullOrEmpty((String)driver) || Strings.isNullOrEmpty((String)url) || Strings.isNullOrEmpty((String)username))) {
            BasicDataSource dataSource = new BasicDataSource();
            dataSource.setDriverClassName(driver);
            dataSource.setUrl(url);
            dataSource.setUsername(username);
            dataSource.setPassword(password);
            return Optional.of(new TracingConfiguration("RDB", (Object)dataSource));
        }
        return Optional.empty();
    }

    public HashMap<String, String> getJobEventRdbConfigurationMap() {
        HashMap<String, String> result = new HashMap<String, String>(4, 1.0f);
        result.put(EnvironmentArgument.EVENT_TRACE_RDB_DRIVER.getKey(), this.getValue(EnvironmentArgument.EVENT_TRACE_RDB_DRIVER));
        result.put(EnvironmentArgument.EVENT_TRACE_RDB_URL.getKey(), this.getValue(EnvironmentArgument.EVENT_TRACE_RDB_URL));
        result.put(EnvironmentArgument.EVENT_TRACE_RDB_USERNAME.getKey(), this.getValue(EnvironmentArgument.EVENT_TRACE_RDB_USERNAME));
        result.put(EnvironmentArgument.EVENT_TRACE_RDB_PASSWORD.getKey(), this.getValue(EnvironmentArgument.EVENT_TRACE_RDB_PASSWORD));
        return result;
    }

    public Optional<String> getMesosRole() {
        String role = this.getValue(EnvironmentArgument.MESOS_ROLE);
        if (Strings.isNullOrEmpty((String)role)) {
            return Optional.empty();
        }
        return Optional.of(role);
    }

    private String getValue(EnvironmentArgument environmentArgument) {
        String result = this.properties.getProperty(environmentArgument.getKey(), environmentArgument.getDefaultValue());
        if (environmentArgument.isRequired()) {
            Preconditions.checkState((!Strings.isNullOrEmpty((String)result) ? 1 : 0) != 0, (Object)String.format("Property `%s` is required.", environmentArgument.getKey()));
        }
        return result;
    }

    @Generated
    public static BootstrapEnvironment getINSTANCE() {
        return INSTANCE;
    }

    public static enum EnvironmentArgument {
        HOSTNAME("hostname", "localhost", true),
        MESOS_URL("mesos_url", "zk://localhost:2181/mesos", true),
        MESOS_ROLE("mesos_role", "", false),
        USER("user", "", false),
        ZOOKEEPER_SERVERS("zk_servers", "localhost:2181", true),
        ZOOKEEPER_NAMESPACE("zk_namespace", "elasticjob-cloud", true),
        ZOOKEEPER_DIGEST("zk_digest", "", false),
        PORT("http_port", "8899", true),
        JOB_STATE_QUEUE_SIZE("job_state_queue_size", "10000", true),
        EVENT_TRACE_RDB_DRIVER("event_trace_rdb_driver", "", false),
        EVENT_TRACE_RDB_URL("event_trace_rdb_url", "", false),
        EVENT_TRACE_RDB_USERNAME("event_trace_rdb_username", "", false),
        EVENT_TRACE_RDB_PASSWORD("event_trace_rdb_password", "", false),
        RECONCILE_INTERVAL_MINUTES("reconcile_interval_minutes", "-1", false),
        AUTH_USERNAME("auth_username", "root", true),
        AUTH_PASSWORD("auth_password", "pwd", true);

        private final String key;
        private final String defaultValue;
        private final boolean required;

        @Generated
        private EnvironmentArgument(String key, String defaultValue, boolean required) {
            this.key = key;
            this.defaultValue = defaultValue;
            this.required = required;
        }

        @Generated
        public String getKey() {
            return this.key;
        }

        @Generated
        public String getDefaultValue() {
            return this.defaultValue;
        }

        @Generated
        public boolean isRequired() {
            return this.required;
        }
    }
}

