/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.cloud.scheduler.statistics.job;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.elasticjob.cloud.scheduler.config.job.CloudJobConfigurationService;
import org.apache.shardingsphere.elasticjob.cloud.scheduler.statistics.job.AbstractStatisticJob;
import org.apache.shardingsphere.elasticjob.cloud.scheduler.statistics.util.StatisticTimeUtils;
import org.apache.shardingsphere.elasticjob.cloud.statistics.StatisticInterval;
import org.apache.shardingsphere.elasticjob.cloud.statistics.rdb.StatisticRdbRepository;
import org.apache.shardingsphere.elasticjob.cloud.statistics.type.job.JobRegisterStatistics;
import org.quartz.CronScheduleBuilder;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.ScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RegisteredJobStatisticJob
extends AbstractStatisticJob {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RegisteredJobStatisticJob.class);
    private CloudJobConfigurationService configurationService;
    private StatisticRdbRepository repository;
    private final StatisticInterval execInterval = StatisticInterval.DAY;

    @Override
    public JobDetail buildJobDetail() {
        return JobBuilder.newJob(this.getClass()).withIdentity(this.getJobName()).build();
    }

    @Override
    public Trigger buildTrigger() {
        return TriggerBuilder.newTrigger().withIdentity(this.getTriggerName()).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)this.execInterval.getCron()).withMisfireHandlingInstructionDoNothing()).build();
    }

    @Override
    public Map<String, Object> getDataMap() {
        HashMap<String, Object> result = new HashMap<String, Object>(2);
        result.put("configurationService", this.configurationService);
        result.put("repository", this.repository);
        return result;
    }

    public void execute(JobExecutionContext context) {
        Optional latestOne = this.repository.findLatestJobRegisterStatistics();
        latestOne.ifPresent(this::fillBlankIfNeeded);
        int registeredCount = this.configurationService.loadAll().size();
        JobRegisterStatistics jobRegisterStatistics = new JobRegisterStatistics(registeredCount, StatisticTimeUtils.getCurrentStatisticTime(this.execInterval));
        log.debug("Add jobRegisterStatistics, registeredCount is:{}", (Object)registeredCount);
        this.repository.add(jobRegisterStatistics);
    }

    private void fillBlankIfNeeded(JobRegisterStatistics latestOne) {
        List<Date> blankDateRange = this.findBlankStatisticTimes(latestOne.getStatisticsTime(), this.execInterval);
        if (!blankDateRange.isEmpty()) {
            log.debug("Fill blank range of jobRegisterStatistics, range is:{}", blankDateRange);
        }
        for (Date each : blankDateRange) {
            this.repository.add(new JobRegisterStatistics(latestOne.getRegisteredCount(), each));
        }
    }

    @Generated
    public void setConfigurationService(CloudJobConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    @Generated
    public void setRepository(StatisticRdbRepository repository) {
        this.repository = repository;
    }

    @Generated
    public RegisteredJobStatisticJob() {
    }

    @Generated
    public RegisteredJobStatisticJob(CloudJobConfigurationService configurationService, StatisticRdbRepository repository) {
        this.configurationService = configurationService;
        this.repository = repository;
    }
}

