/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.fenzo.plugins;

import com.netflix.fenzo.ConstraintEvaluator;
import com.netflix.fenzo.TaskAssignmentResult;
import com.netflix.fenzo.TaskRequest;
import com.netflix.fenzo.TaskTrackerState;
import com.netflix.fenzo.VirtualMachineCurrentState;
import java.util.Collection;

public final class ExclusiveHostConstraint
implements ConstraintEvaluator {
    @Override
    public String getName() {
        return ExclusiveHostConstraint.class.getName();
    }

    @Override
    public ConstraintEvaluator.Result evaluate(TaskRequest taskRequest, VirtualMachineCurrentState targetVM, TaskTrackerState taskTrackerState) {
        Collection<TaskRequest> runningTasks = targetVM.getRunningTasks();
        if (runningTasks != null && !runningTasks.isEmpty()) {
            return new ConstraintEvaluator.Result(false, "Already has " + runningTasks.size() + " tasks running on it");
        }
        Collection<TaskAssignmentResult> tasksCurrentlyAssigned = targetVM.getTasksCurrentlyAssigned();
        if (tasksCurrentlyAssigned != null && !tasksCurrentlyAssigned.isEmpty()) {
            return new ConstraintEvaluator.Result(false, "Already has " + tasksCurrentlyAssigned.size() + " assigned on it");
        }
        return new ConstraintEvaluator.Result(true, "");
    }
}

