/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.fenzo.queues.tiered;

import com.netflix.fenzo.VMResource;
import com.netflix.fenzo.queues.Assignable;
import com.netflix.fenzo.queues.QAttributes;
import com.netflix.fenzo.queues.QueuableTask;
import com.netflix.fenzo.queues.TaskQueue;
import com.netflix.fenzo.queues.TaskQueueException;
import com.netflix.fenzo.queues.UsageTrackedQueue;
import com.netflix.fenzo.sla.ResAllocs;
import com.netflix.fenzo.sla.ResAllocsUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class QueueBucket
implements UsageTrackedQueue {
    private static final Logger logger = LoggerFactory.getLogger(QueueBucket.class);
    private final int tierNumber;
    private final String name;
    private final UsageTrackedQueue.ResUsage totals;
    private final ResAllocs emptyBucketGuarantees;
    private ResAllocs bucketGuarantees;
    private ResAllocs effectiveUsage;
    private final LinkedHashMap<String, QueuableTask> queuedTasks;
    private final LinkedHashMap<String, QueuableTask> launchedTasks;
    private final LinkedHashMap<String, QueuableTask> assignedTasks;
    private Iterator<Map.Entry<String, QueuableTask>> iterator = null;
    private ResAllocs tierResources;
    private final BiFunction<Integer, String, Double> allocsShareGetter;
    private final UsageTrackedQueue.ResUsage tierUsage;

    QueueBucket(int tierNumber, String name, UsageTrackedQueue.ResUsage tierUsage, BiFunction<Integer, String, Double> allocsShareGetter) {
        this.tierNumber = tierNumber;
        this.name = name;
        this.tierUsage = tierUsage;
        this.totals = new UsageTrackedQueue.ResUsage();
        this.bucketGuarantees = this.emptyBucketGuarantees = ResAllocsUtil.emptyOf(name);
        this.queuedTasks = new LinkedHashMap();
        this.launchedTasks = new LinkedHashMap();
        this.assignedTasks = new LinkedHashMap();
        this.allocsShareGetter = allocsShareGetter == null ? (integer, s) -> 1.0 : allocsShareGetter;
    }

    void setBucketGuarantees(ResAllocs bucketGuarantees) {
        this.bucketGuarantees = bucketGuarantees == null ? this.emptyBucketGuarantees : bucketGuarantees;
        this.updateEffectiveUsage();
    }

    ResAllocs getBucketGuarantees() {
        return this.bucketGuarantees;
    }

    @Override
    public void queueTask(QueuableTask t) throws TaskQueueException {
        if (this.iterator != null) {
            throw new ConcurrentModificationException("Must reset before queuing tasks");
        }
        if (this.queuedTasks.get(t.getId()) != null) {
            throw new TaskQueueException("Duplicate task not allowed, task with id " + t.getId());
        }
        if (this.launchedTasks.get(t.getId()) != null) {
            throw new TaskQueueException("Task already launched, can't queue, id=" + t.getId());
        }
        this.queuedTasks.put(t.getId(), t);
    }

    @Override
    public Assignable<QueuableTask> nextTaskToLaunch() throws TaskQueueException {
        if (this.iterator == null) {
            this.iterator = this.queuedTasks.entrySet().iterator();
            if (!this.assignedTasks.isEmpty()) {
                throw new TaskQueueException(this.assignedTasks.size() + " tasks still assigned but not launched");
            }
        }
        while (this.iterator.hasNext()) {
            Map.Entry<String, QueuableTask> nextTask = this.iterator.next();
            if (nextTask.getValue().getReadyAt() > System.currentTimeMillis()) continue;
            return Assignable.success(nextTask.getValue());
        }
        return null;
    }

    @Override
    public void assignTask(QueuableTask t) throws TaskQueueException {
        if (this.iterator == null) {
            throw new TaskQueueException(new IllegalStateException("assign called on task " + t.getId() + " while not iterating over tasks"));
        }
        if (this.queuedTasks.get(t.getId()) == null) {
            throw new TaskQueueException("Task not in queue for assigning, id=" + t.getId());
        }
        if (this.assignedTasks.get(t.getId()) != null) {
            throw new TaskQueueException("Task already assigned, id=" + t.getId());
        }
        if (this.launchedTasks.get(t.getId()) != null) {
            throw new TaskQueueException("Task already launched, id=" + t.getId());
        }
        this.assignedTasks.put(t.getId(), t);
        this.addUsage(t);
    }

    @Override
    public boolean launchTask(QueuableTask t) throws TaskQueueException {
        if (this.iterator != null) {
            throw new ConcurrentModificationException("Must reset before launching tasks");
        }
        if (this.launchedTasks.get(t.getId()) != null) {
            throw new TaskQueueException("Task already launched, id=" + t.getId());
        }
        this.queuedTasks.remove(t.getId());
        QueuableTask removed = (QueuableTask)this.assignedTasks.remove(t.getId());
        this.launchedTasks.put(t.getId(), t);
        if (removed == null) {
            this.addUsage(t);
            return true;
        }
        return false;
    }

    @Override
    public QueuableTask removeTask(String id, QAttributes qAttributes) throws TaskQueueException {
        if (this.iterator != null) {
            throw new TaskQueueException("Must reset before removing tasks");
        }
        QueuableTask removed = (QueuableTask)this.queuedTasks.remove(id);
        if (removed == null) {
            removed = (QueuableTask)this.assignedTasks.remove(id);
            if (removed == null) {
                removed = (QueuableTask)this.launchedTasks.remove(id);
            }
            if (removed != null) {
                this.removeUsage(removed);
            }
        }
        return removed;
    }

    private void addUsage(QueuableTask t) {
        this.totals.addUsage(t);
        this.updateEffectiveUsage();
    }

    private void removeUsage(QueuableTask removed) {
        this.totals.remUsage(removed);
        this.updateEffectiveUsage();
    }

    private void updateEffectiveUsage() {
        this.effectiveUsage = ResAllocsUtil.ceilingOf(this.totals.getResAllocsWrapper(), this.bucketGuarantees);
    }

    @Override
    public double getDominantUsageShare() {
        ResAllocs total = this.tierResources == null ? this.tierUsage.getResAllocsWrapper() : this.tierResources;
        return this.totals.getDominantResUsageFrom(total) / Math.max(1.0E-4, this.allocsShareGetter.apply(this.tierNumber, this.name));
    }

    @Override
    public void setTaskReadyTime(String taskId, QAttributes qAttributes, long when) throws TaskQueueException {
        if (this.iterator != null) {
            throw new TaskQueueException("Must reset before setting task ready time");
        }
        QueuableTask task = this.queuedTasks.get(taskId);
        if (task != null) {
            task.safeSetReadyAt(when);
        }
    }

    public boolean hasGuaranteedCapacityFor(QueuableTask task) {
        if (!ResAllocsUtil.isBounded(this.totals.getResAllocsWrapper(), this.bucketGuarantees)) {
            return false;
        }
        ResAllocs summed = ResAllocsUtil.add(this.totals.getResAllocsWrapper(), task);
        return ResAllocsUtil.isBounded(summed, this.bucketGuarantees);
    }

    public ResAllocs getEffectiveUsage() {
        return this.effectiveUsage;
    }

    public String getBucketCapacityAsString() {
        StringBuilder sb = new StringBuilder();
        if (this.bucketGuarantees != null) {
            sb.append("Bucket ").append(this.name).append(" Total Capacity: ").append(this.bucketGuarantees.getAsString());
        }
        if (this.effectiveUsage != null) {
            sb.append("\nBucket ").append(this.name).append(" Used Capacity: ").append(this.effectiveUsage.getAsString());
        }
        return sb.toString();
    }

    @Override
    public void reset() {
        this.iterator = null;
    }

    @Override
    public Map<TaskQueue.TaskState, Collection<QueuableTask>> getAllTasks() throws TaskQueueException {
        if (this.iterator != null) {
            throw new TaskQueueException("Must reset before getting list of tasks");
        }
        HashMap<TaskQueue.TaskState, Collection<QueuableTask>> result = new HashMap<TaskQueue.TaskState, Collection<QueuableTask>>();
        result.put(TaskQueue.TaskState.QUEUED, Collections.unmodifiableCollection(this.queuedTasks.values()));
        result.put(TaskQueue.TaskState.LAUNCHED, Collections.unmodifiableCollection(this.launchedTasks.values()));
        return result;
    }

    @Override
    public void setTotalResources(Map<VMResource, Double> totalResourcesMap) {
        this.tierResources = ResAllocsUtil.toResAllocs("tier", totalResourcesMap);
    }

    public void setTotalResources(ResAllocs tierResources) {
        this.tierResources = tierResources;
    }

    int size() {
        return this.queuedTasks.size() + this.launchedTasks.size();
    }

    int getTierNumber() {
        return this.tierNumber;
    }

    String getName() {
        return this.name;
    }
}

