/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.fenzo.samples;

import com.netflix.fenzo.ConstraintEvaluator;
import com.netflix.fenzo.SchedulingResult;
import com.netflix.fenzo.TaskAssignmentResult;
import com.netflix.fenzo.TaskRequest;
import com.netflix.fenzo.TaskScheduler;
import com.netflix.fenzo.TaskSchedulingService;
import com.netflix.fenzo.VMAssignmentResult;
import com.netflix.fenzo.VMTaskFitnessCalculator;
import com.netflix.fenzo.VirtualMachineLease;
import com.netflix.fenzo.functions.Action0;
import com.netflix.fenzo.functions.Action1;
import com.netflix.fenzo.plugins.BinPackingFitnessCalculators;
import com.netflix.fenzo.plugins.VMLeaseObject;
import com.netflix.fenzo.queues.QAttributes;
import com.netflix.fenzo.queues.QueuableTask;
import com.netflix.fenzo.queues.TaskQueue;
import com.netflix.fenzo.queues.TaskQueues;
import com.netflix.fenzo.samples.SampleFramework;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.mesos.MesosSchedulerDriver;
import org.apache.mesos.Protos;
import org.apache.mesos.Scheduler;
import org.apache.mesos.SchedulerDriver;

public class SampleQbasedScheduling {
    private static final QAttributes qAttribs = new QAttributes.QAttributesAdaptor(0, "onlyBucket");
    private static final ConcurrentMap<String, QueuableTask> allTasks = new ConcurrentHashMap<String, QueuableTask>();
    private static final ConcurrentMap<String, String> tasksToHostnameMap = new ConcurrentHashMap<String, String>();

    public static void main(String[] args) throws Exception {
        if (args.length != 1) {
            System.err.println("Must provide one argument - Mesos master location string");
            System.exit(1);
        }
        int numTasks = 10;
        AtomicInteger numTasksCompleted = new AtomicInteger();
        TaskScheduler taskScheduler = new TaskScheduler.Builder().withFitnessCalculator(BinPackingFitnessCalculators.cpuMemBinPacker).withLeaseOfferExpirySecs(1000000L).withLeaseRejectAction(new Action1<VirtualMachineLease>(){

            @Override
            public void call(VirtualMachineLease v) {
                System.out.println("Unexpected to reject lease on " + v.hostname());
            }
        }).build();
        TaskQueue queue = TaskQueues.createTieredQueue(2);
        AtomicReference<TaskSchedulingService> schedSvcGetter = new AtomicReference<TaskSchedulingService>();
        MesosScheduler mesosSchedulerCallback = new MesosScheduler(numTasksCompleted, schedSvcGetter);
        Protos.FrameworkInfo framework = Protos.FrameworkInfo.newBuilder().setName("Sample Fenzo Framework").setUser("").build();
        final MesosSchedulerDriver driver = new MesosSchedulerDriver((Scheduler)mesosSchedulerCallback, framework, args[0]);
        final AtomicInteger schedCounter = new AtomicInteger();
        final TaskSchedulingService schedulingService = new TaskSchedulingService.Builder().withLoopIntervalMillis(1000L).withMaxDelayMillis(1500L).withPreSchedulingLoopHook(new Action0(){

            @Override
            public void call() {
                System.out.println("Starting scheduling iteration " + schedCounter.incrementAndGet());
            }
        }).withTaskQueue(queue).withTaskScheduler(taskScheduler).withSchedulingResultCallback(new Action1<SchedulingResult>(){

            @Override
            public void call(SchedulingResult schedulingResult) {
                List<Exception> exceptions = schedulingResult.getExceptions();
                if (exceptions != null && !exceptions.isEmpty()) {
                    System.out.println("Exceptions from scheduling iteration:");
                    for (Exception e : exceptions) {
                        e.printStackTrace();
                    }
                } else {
                    for (Map.Entry<String, VMAssignmentResult> e : schedulingResult.getResultMap().entrySet()) {
                        ArrayList<Protos.OfferID> offers = new ArrayList<Protos.OfferID>();
                        for (VirtualMachineLease l : e.getValue().getLeasesUsed()) {
                            offers.add(l.getOffer().getId());
                        }
                        ArrayList<Protos.TaskInfo> taskInfos = new ArrayList<Protos.TaskInfo>();
                        for (TaskAssignmentResult r : e.getValue().getTasksAssigned()) {
                            taskInfos.add(SampleFramework.getTaskInfo(e.getValue().getLeasesUsed().iterator().next().getOffer().getSlaveId(), r.getTaskId(), "sleep 2"));
                            tasksToHostnameMap.put(r.getTaskId(), r.getHostname());
                        }
                        driver.launchTasks(offers, taskInfos);
                    }
                }
            }
        }).build();
        schedSvcGetter.set(schedulingService);
        mesosSchedulerCallback.leaseAction = new Action1<List<Protos.Offer>>(){

            @Override
            public void call(List<Protos.Offer> offers) {
                ArrayList<VMLeaseObject> leases = new ArrayList<VMLeaseObject>();
                for (Protos.Offer o : offers) {
                    leases.add(new VMLeaseObject(o));
                }
                schedulingService.addLeases(leases);
            }
        };
        schedulingService.start();
        new Thread(){

            @Override
            public void run() {
                driver.run();
            }
        }.start();
        for (int i = 0; i < numTasks; ++i) {
            QueuableTask task = SampleQbasedScheduling.getTask(i);
            allTasks.put(task.getId(), task);
            queue.queueTask(task);
        }
        while (numTasksCompleted.get() < numTasks) {
            Thread.sleep(1000L);
            System.out.println("        #tasks completed: " + numTasksCompleted.get() + " of " + numTasks);
        }
        final CountDownLatch latch = new CountDownLatch(1);
        schedulingService.requestAllTasks(new Action1<Map<TaskQueue.TaskState, Collection<QueuableTask>>>(){

            @Override
            public void call(Map<TaskQueue.TaskState, Collection<QueuableTask>> taskStateCollectionMap) {
                System.out.println("Fenzo queue has " + taskStateCollectionMap.size() + " items");
                latch.countDown();
            }
        });
        if (!latch.await(5L, TimeUnit.SECONDS)) {
            System.err.println("Timeout waiting for listing all tasks in Fenzo queues");
        }
        System.out.println("ALL DONE");
        System.exit(0);
    }

    private static QueuableTask getTask(final int i) {
        return new QueuableTask(){

            @Override
            public QAttributes getQAttributes() {
                return qAttribs;
            }

            @Override
            public String getId() {
                return "Task-" + i;
            }

            @Override
            public String taskGroupName() {
                return "groupA";
            }

            @Override
            public double getCPUs() {
                return 1.0;
            }

            @Override
            public double getMemory() {
                return 100.0;
            }

            @Override
            public double getNetworkMbps() {
                return 0.0;
            }

            @Override
            public double getDisk() {
                return 0.0;
            }

            @Override
            public int getPorts() {
                return 0;
            }

            @Override
            public Map<String, Double> getScalarRequests() {
                return null;
            }

            @Override
            public Map<String, TaskRequest.NamedResourceSetRequest> getCustomNamedResources() {
                return null;
            }

            @Override
            public List<? extends ConstraintEvaluator> getHardConstraints() {
                return null;
            }

            @Override
            public List<? extends VMTaskFitnessCalculator> getSoftConstraints() {
                return null;
            }

            @Override
            public void setAssignedResources(TaskRequest.AssignedResources assignedResources) {
            }

            @Override
            public TaskRequest.AssignedResources getAssignedResources() {
                return null;
            }
        };
    }

    private static class MesosScheduler
    implements Scheduler {
        private final AtomicInteger numTasksCompleted;
        private final AtomicReference<TaskSchedulingService> schedSvcGetter;
        private Action1<List<Protos.Offer>> leaseAction = null;

        MesosScheduler(AtomicInteger numTasksCompleted, AtomicReference<TaskSchedulingService> schedSvcGetter) {
            this.numTasksCompleted = numTasksCompleted;
            this.schedSvcGetter = schedSvcGetter;
        }

        public void registered(SchedulerDriver driver, Protos.FrameworkID frameworkId, Protos.MasterInfo masterInfo) {
            System.out.println("Mesos scheduler registered");
        }

        public void reregistered(SchedulerDriver driver, Protos.MasterInfo masterInfo) {
            System.out.println("Mesos scheduler re-registered");
        }

        public void resourceOffers(SchedulerDriver driver, List<Protos.Offer> offers) {
            this.leaseAction.call(offers);
        }

        public void offerRescinded(SchedulerDriver driver, Protos.OfferID offerId) {
            System.out.println("Unexpected offers Rescinded");
        }

        public void statusUpdate(SchedulerDriver driver, Protos.TaskStatus status) {
            switch (status.getState()) {
                case TASK_FAILED: 
                case TASK_LOST: 
                case TASK_FINISHED: {
                    System.out.println("Task status for " + status.getTaskId().getValue() + ": " + status.getState());
                    this.schedSvcGetter.get().removeTask(status.getTaskId().getValue(), ((QueuableTask)allTasks.get(status.getTaskId().getValue())).getQAttributes(), (String)tasksToHostnameMap.get(status.getTaskId().getValue()));
                    this.numTasksCompleted.incrementAndGet();
                }
            }
        }

        public void frameworkMessage(SchedulerDriver driver, Protos.ExecutorID executorId, Protos.SlaveID slaveId, byte[] data) {
        }

        public void disconnected(SchedulerDriver driver) {
            System.out.println("Mesos driver disconnected");
        }

        public void slaveLost(SchedulerDriver driver, Protos.SlaveID slaveId) {
            System.out.println("Mesos agent lost");
        }

        public void executorLost(SchedulerDriver driver, Protos.ExecutorID executorId, Protos.SlaveID slaveId, int status) {
            System.out.println("Mesos executor lost");
        }

        public void error(SchedulerDriver driver, String message) {
            System.out.println("Unexpected mesos scheduler error: " + message);
        }
    }
}

