/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.lite.spring.boot.job;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.Map;
import lombok.Generated;
import org.apache.shardingsphere.elasticjob.api.ElasticJob;
import org.apache.shardingsphere.elasticjob.api.JobConfiguration;
import org.apache.shardingsphere.elasticjob.lite.api.bootstrap.impl.OneOffJobBootstrap;
import org.apache.shardingsphere.elasticjob.lite.api.bootstrap.impl.ScheduleJobBootstrap;
import org.apache.shardingsphere.elasticjob.lite.spring.boot.job.ElasticJobConfigurationProperties;
import org.apache.shardingsphere.elasticjob.lite.spring.boot.job.ElasticJobProperties;
import org.apache.shardingsphere.elasticjob.lite.spring.boot.tracing.TracingProperties;
import org.apache.shardingsphere.elasticjob.reg.base.CoordinatorRegistryCenter;
import org.apache.shardingsphere.elasticjob.tracing.api.TracingConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.SingletonBeanRegistry;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;

public class ElasticJobBootstrapConfiguration
implements SmartInitializingSingleton,
ApplicationContextAware {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ElasticJobBootstrapConfiguration.class);
    private ApplicationContext applicationContext;

    public void afterSingletonsInstantiated() {
        log.info("creating Job Bootstrap Beans");
        this.createJobBootstrapBeans();
        log.info("Job Bootstrap Beans created.");
    }

    public void createJobBootstrapBeans() {
        ElasticJobProperties elasticJobProperties = (ElasticJobProperties)this.applicationContext.getBean(ElasticJobProperties.class);
        ConfigurableListableBeanFactory singletonBeanRegistry = ((ConfigurableApplicationContext)this.applicationContext).getBeanFactory();
        CoordinatorRegistryCenter registryCenter = (CoordinatorRegistryCenter)this.applicationContext.getBean(CoordinatorRegistryCenter.class);
        TracingConfiguration<?> tracingConfig = this.getTracingConfiguration();
        this.constructJobBootstraps(elasticJobProperties, (SingletonBeanRegistry)singletonBeanRegistry, registryCenter, tracingConfig);
    }

    private TracingConfiguration<?> getTracingConfiguration() {
        Map tracingConfigurationBeans = this.applicationContext.getBeansOfType(TracingConfiguration.class);
        if (tracingConfigurationBeans.isEmpty()) {
            return null;
        }
        if (1 == tracingConfigurationBeans.size()) {
            return (TracingConfiguration)tracingConfigurationBeans.values().iterator().next();
        }
        throw new BeanCreationException("More than one [org.apache.shardingsphere.elasticjob.tracing.api.TracingConfiguration] beans found. Consider disabling [org.apache.shardingsphere.elasticjob.tracing.boot.ElasticJobTracingAutoConfiguration].");
    }

    private void constructJobBootstraps(ElasticJobProperties elasticJobProperties, SingletonBeanRegistry singletonBeanRegistry, CoordinatorRegistryCenter registryCenter, TracingConfiguration<?> tracingConfig) {
        for (Map.Entry<String, ElasticJobConfigurationProperties> entry : elasticJobProperties.getJobs().entrySet()) {
            ElasticJobConfigurationProperties jobConfigurationProperties = entry.getValue();
            Preconditions.checkArgument((null != jobConfigurationProperties.getElasticJobClass() || !Strings.isNullOrEmpty((String)jobConfigurationProperties.getElasticJobType()) ? 1 : 0) != 0, (Object)"Please specific [elasticJobClass] or [elasticJobType] under job configuration.");
            Preconditions.checkArgument((null == jobConfigurationProperties.getElasticJobClass() || Strings.isNullOrEmpty((String)jobConfigurationProperties.getElasticJobType()) ? 1 : 0) != 0, (Object)"[elasticJobClass] and [elasticJobType] are mutually exclusive.");
            if (null != jobConfigurationProperties.getElasticJobClass()) {
                this.registerClassedJob(entry.getKey(), entry.getValue().getJobBootstrapBeanName(), singletonBeanRegistry, registryCenter, tracingConfig, jobConfigurationProperties);
                continue;
            }
            if (Strings.isNullOrEmpty((String)jobConfigurationProperties.getElasticJobType())) continue;
            this.registerTypedJob(entry.getKey(), entry.getValue().getJobBootstrapBeanName(), singletonBeanRegistry, registryCenter, tracingConfig, jobConfigurationProperties);
        }
    }

    private void registerClassedJob(String jobName, String jobBootstrapBeanName, SingletonBeanRegistry singletonBeanRegistry, CoordinatorRegistryCenter registryCenter, TracingConfiguration<?> tracingConfig, ElasticJobConfigurationProperties jobConfigurationProperties) {
        JobConfiguration jobConfig = jobConfigurationProperties.toJobConfiguration(jobName);
        this.jobExtraConfigurations(jobConfig, tracingConfig);
        ElasticJob elasticJob = (ElasticJob)this.applicationContext.getBean(jobConfigurationProperties.getElasticJobClass());
        if (Strings.isNullOrEmpty((String)jobConfig.getCron())) {
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)jobBootstrapBeanName) ? 1 : 0) != 0, (Object)"The property [jobBootstrapBeanName] is required for One-off job.");
            singletonBeanRegistry.registerSingleton(jobBootstrapBeanName, (Object)new OneOffJobBootstrap(registryCenter, elasticJob, jobConfig));
        } else {
            String beanName = !Strings.isNullOrEmpty((String)jobBootstrapBeanName) ? jobBootstrapBeanName : jobConfig.getJobName() + "ScheduleJobBootstrap";
            singletonBeanRegistry.registerSingleton(beanName, (Object)new ScheduleJobBootstrap(registryCenter, elasticJob, jobConfig));
        }
    }

    private void registerTypedJob(String jobName, String jobBootstrapBeanName, SingletonBeanRegistry singletonBeanRegistry, CoordinatorRegistryCenter registryCenter, TracingConfiguration<?> tracingConfig, ElasticJobConfigurationProperties jobConfigurationProperties) {
        JobConfiguration jobConfig = jobConfigurationProperties.toJobConfiguration(jobName);
        this.jobExtraConfigurations(jobConfig, tracingConfig);
        if (Strings.isNullOrEmpty((String)jobConfig.getCron())) {
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)jobBootstrapBeanName) ? 1 : 0) != 0, (Object)"The property [jobBootstrapBeanName] is required for One-off job.");
            singletonBeanRegistry.registerSingleton(jobBootstrapBeanName, (Object)new OneOffJobBootstrap(registryCenter, jobConfigurationProperties.getElasticJobType(), jobConfig));
        } else {
            String beanName = !Strings.isNullOrEmpty((String)jobBootstrapBeanName) ? jobBootstrapBeanName : jobConfig.getJobName() + "ScheduleJobBootstrap";
            singletonBeanRegistry.registerSingleton(beanName, (Object)new ScheduleJobBootstrap(registryCenter, jobConfigurationProperties.getElasticJobType(), jobConfig));
        }
    }

    private void jobExtraConfigurations(JobConfiguration jobConfig, TracingConfiguration<?> tracingConfig) {
        if (null == tracingConfig) {
            return;
        }
        TracingProperties tracingProperties = (TracingProperties)this.applicationContext.getBean(TracingProperties.class);
        Preconditions.checkArgument((tracingProperties.getIncludeJobNames().isEmpty() || tracingProperties.getExcludeJobNames().isEmpty() ? 1 : 0) != 0, (Object)"[tracing.includeJobNames] and [tracing.excludeJobNames] are mutually exclusive.");
        if ((tracingProperties.getIncludeJobNames().isEmpty() || tracingProperties.getIncludeJobNames().contains(jobConfig.getJobName())) && !tracingProperties.getExcludeJobNames().contains(jobConfig.getJobName())) {
            jobConfig.getExtraConfigurations().add(tracingConfig);
        }
    }

    @Generated
    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }
}

