/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.spi.listener.param;

import java.io.Serializable;
import java.util.Map;
import lombok.Generated;
import org.apache.shardingsphere.elasticjob.spi.executor.item.param.ShardingContext;

public final class ShardingContexts
implements Serializable {
    private static final long serialVersionUID = -4585977349142082152L;
    private final String taskId;
    private final String jobName;
    private final int shardingTotalCount;
    private final String jobParameter;
    private final Map<Integer, String> shardingItemParameters;
    private int jobEventSamplingCount;
    private int currentJobEventSamplingCount;
    private boolean allowSendJobEvent = true;

    public ShardingContexts(String taskId, String jobName, int shardingTotalCount, String jobParameter, Map<Integer, String> shardingItemParameters, int jobEventSamplingCount) {
        this.taskId = taskId;
        this.jobName = jobName;
        this.shardingTotalCount = shardingTotalCount;
        this.jobParameter = jobParameter;
        this.shardingItemParameters = shardingItemParameters;
        this.jobEventSamplingCount = jobEventSamplingCount;
    }

    public ShardingContext createShardingContext(int shardingItem) {
        return new ShardingContext(this.jobName, this.taskId, this.shardingTotalCount, this.jobParameter, shardingItem, this.shardingItemParameters.get(shardingItem));
    }

    @Generated
    public ShardingContexts(String taskId, String jobName, int shardingTotalCount, String jobParameter, Map<Integer, String> shardingItemParameters) {
        this.taskId = taskId;
        this.jobName = jobName;
        this.shardingTotalCount = shardingTotalCount;
        this.jobParameter = jobParameter;
        this.shardingItemParameters = shardingItemParameters;
    }

    @Generated
    public String getTaskId() {
        return this.taskId;
    }

    @Generated
    public String getJobName() {
        return this.jobName;
    }

    @Generated
    public int getShardingTotalCount() {
        return this.shardingTotalCount;
    }

    @Generated
    public String getJobParameter() {
        return this.jobParameter;
    }

    @Generated
    public Map<Integer, String> getShardingItemParameters() {
        return this.shardingItemParameters;
    }

    @Generated
    public int getJobEventSamplingCount() {
        return this.jobEventSamplingCount;
    }

    @Generated
    public int getCurrentJobEventSamplingCount() {
        return this.currentJobEventSamplingCount;
    }

    @Generated
    public boolean isAllowSendJobEvent() {
        return this.allowSendJobEvent;
    }

    @Generated
    public String toString() {
        return "ShardingContexts(taskId=" + this.getTaskId() + ", jobName=" + this.getJobName() + ", shardingTotalCount=" + this.getShardingTotalCount() + ", jobParameter=" + this.getJobParameter() + ", shardingItemParameters=" + this.getShardingItemParameters() + ", jobEventSamplingCount=" + this.getJobEventSamplingCount() + ", currentJobEventSamplingCount=" + this.getCurrentJobEventSamplingCount() + ", allowSendJobEvent=" + this.isAllowSendJobEvent() + ")";
    }

    @Generated
    public void setCurrentJobEventSamplingCount(int currentJobEventSamplingCount) {
        this.currentJobEventSamplingCount = currentJobEventSamplingCount;
    }

    @Generated
    public void setAllowSendJobEvent(boolean allowSendJobEvent) {
        this.allowSendJobEvent = allowSendJobEvent;
    }
}

