/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.kernel.internal.sharding;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.shardingsphere.elasticjob.api.JobConfiguration;
import org.apache.shardingsphere.elasticjob.kernel.internal.config.ConfigurationService;
import org.apache.shardingsphere.elasticjob.kernel.internal.schedule.JobRegistry;
import org.apache.shardingsphere.elasticjob.kernel.internal.sharding.JobInstance;
import org.apache.shardingsphere.elasticjob.kernel.internal.sharding.ShardingNode;
import org.apache.shardingsphere.elasticjob.kernel.internal.storage.JobNodeStorage;
import org.apache.shardingsphere.elasticjob.reg.base.CoordinatorRegistryCenter;
import org.apache.shardingsphere.elasticjob.spi.listener.param.ShardingContexts;

public final class ExecutionService {
    private final String jobName;
    private final JobNodeStorage jobNodeStorage;
    private final ConfigurationService configService;

    public ExecutionService(CoordinatorRegistryCenter regCenter, String jobName) {
        this.jobName = jobName;
        this.jobNodeStorage = new JobNodeStorage(regCenter, jobName);
        this.configService = new ConfigurationService(regCenter, jobName);
    }

    public void registerJobBegin(ShardingContexts shardingContexts) {
        JobRegistry.getInstance().setJobRunning(this.jobName, true);
        JobConfiguration jobConfig = this.configService.load(true);
        if (!jobConfig.isMonitorExecution()) {
            return;
        }
        String jobInstanceId = JobRegistry.getInstance().getJobInstance(this.jobName).getJobInstanceId();
        Iterator iterator = shardingContexts.getShardingItemParameters().keySet().iterator();
        while (iterator.hasNext()) {
            int each = (Integer)iterator.next();
            if (jobConfig.isFailover()) {
                this.jobNodeStorage.fillJobNode(ShardingNode.getRunningNode(each), jobInstanceId);
                continue;
            }
            this.jobNodeStorage.fillEphemeralJobNode(ShardingNode.getRunningNode(each), jobInstanceId);
        }
    }

    public void registerJobCompleted(ShardingContexts shardingContexts) {
        JobRegistry.getInstance().setJobRunning(this.jobName, false);
        if (!this.configService.load(true).isMonitorExecution()) {
            return;
        }
        Iterator iterator = shardingContexts.getShardingItemParameters().keySet().iterator();
        while (iterator.hasNext()) {
            int each = (Integer)iterator.next();
            this.jobNodeStorage.removeJobNodeIfExisted(ShardingNode.getRunningNode(each));
        }
    }

    public void clearAllRunningInfo() {
        this.clearRunningInfo(this.getAllItems());
    }

    public void clearRunningInfo(List<Integer> items) {
        for (int each : items) {
            this.jobNodeStorage.removeJobNodeIfExisted(ShardingNode.getRunningNode(each));
        }
    }

    public boolean hasRunningItems(Collection<Integer> items) {
        JobConfiguration jobConfig = this.configService.load(true);
        if (!jobConfig.isMonitorExecution()) {
            return false;
        }
        for (int each : items) {
            if (!this.jobNodeStorage.isJobNodeExisted(ShardingNode.getRunningNode(each))) continue;
            return true;
        }
        return false;
    }

    public boolean hasRunningItems() {
        return this.hasRunningItems(this.getAllItems());
    }

    private List<Integer> getAllItems() {
        int shardingTotalCount = this.configService.load(true).getShardingTotalCount();
        ArrayList<Integer> result = new ArrayList<Integer>(shardingTotalCount);
        for (int i = 0; i < shardingTotalCount; ++i) {
            result.add(i);
        }
        return result;
    }

    public Map<Integer, JobInstance> getAllRunningItems() {
        int shardingTotalCount = this.configService.load(true).getShardingTotalCount();
        LinkedHashMap<Integer, JobInstance> result = new LinkedHashMap<Integer, JobInstance>(shardingTotalCount, 1.0f);
        for (int i = 0; i < shardingTotalCount; ++i) {
            String data = this.jobNodeStorage.getJobNodeData(ShardingNode.getRunningNode(i));
            if (Strings.isNullOrEmpty((String)data)) continue;
            result.put(i, new JobInstance(data));
        }
        return result;
    }

    public boolean misfireIfHasRunningItems(Collection<Integer> items) {
        if (!this.hasRunningItems(items)) {
            return false;
        }
        this.setMisfire(items);
        return true;
    }

    public void setMisfire(Collection<Integer> items) {
        for (int each : items) {
            this.jobNodeStorage.createJobNodeIfNeeded(ShardingNode.getMisfireNode(each));
        }
    }

    public List<Integer> getMisfiredJobItems(Collection<Integer> items) {
        ArrayList<Integer> result = new ArrayList<Integer>(items.size());
        for (int each : items) {
            if (!this.jobNodeStorage.isJobNodeExisted(ShardingNode.getMisfireNode(each))) continue;
            result.add(each);
        }
        return result;
    }

    public void clearMisfire(Collection<Integer> items) {
        for (int each : items) {
            this.jobNodeStorage.removeJobNodeIfExisted(ShardingNode.getMisfireNode(each));
        }
    }

    public List<Integer> getDisabledItems(List<Integer> items) {
        ArrayList<Integer> result = new ArrayList<Integer>(items.size());
        for (int each : items) {
            if (!this.jobNodeStorage.isJobNodeExisted(ShardingNode.getDisabledNode(each))) continue;
            result.add(each);
        }
        return result;
    }
}

