/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.observation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.observation.ObservationManager;
import org.apache.jackrabbit.core.HierarchyManager;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.id.ItemId;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.nodetype.NodeTypeImpl;
import org.apache.jackrabbit.core.observation.ChangeLogBasedHierarchyMgr;
import org.apache.jackrabbit.core.observation.EventDispatcher;
import org.apache.jackrabbit.core.observation.EventState;
import org.apache.jackrabbit.core.observation.ObservationManagerImpl;
import org.apache.jackrabbit.core.state.ChangeLog;
import org.apache.jackrabbit.core.state.ChildNodeEntry;
import org.apache.jackrabbit.core.state.ItemState;
import org.apache.jackrabbit.core.state.ItemStateException;
import org.apache.jackrabbit.core.state.ItemStateManager;
import org.apache.jackrabbit.core.state.NoSuchItemStateException;
import org.apache.jackrabbit.core.state.NodeState;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.commons.name.PathBuilder;
import org.apache.jackrabbit.spi.commons.name.PathFactoryImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EventStateCollection {
    private static Logger log = LoggerFactory.getLogger(EventStateCollection.class);
    private final List<EventState> events = new ArrayList<EventState>();
    private final EventDispatcher dispatcher;
    private final SessionImpl session;
    private final Path pathPrefix;
    private long timestamp = System.currentTimeMillis();
    private String userData;

    public EventStateCollection(EventDispatcher dispatcher, SessionImpl session, Path pathPrefix) {
        this.dispatcher = dispatcher;
        this.session = session;
        this.pathPrefix = pathPrefix;
        if (session != null) {
            try {
                ObservationManager manager = session.getWorkspace().getObservationManager();
                this.userData = ((ObservationManagerImpl)manager).getUserData();
            }
            catch (RepositoryException e) {
                this.userData = null;
            }
        } else {
            this.userData = null;
        }
    }

    public void createEventStates(NodeId rootNodeId, ChangeLog changes, ItemStateManager stateMgr) throws ItemStateException {
        Path path;
        Set<Name> mixins;
        NodeTypeImpl nodeType;
        NodeState parent;
        Set<Name> mixins2;
        NodeTypeImpl nodeType2;
        NodeState n;
        ChangeLogBasedHierarchyMgr hmgr = new ChangeLogBasedHierarchyMgr(rootNodeId, stateMgr, changes);
        for (ItemState state : changes.modifiedStates()) {
            if (state.isNode()) {
                n = (NodeState)state;
                if (n.hasOverlayedState()) {
                    NodeId oldParentId = n.getOverlayedState().getParentId();
                    NodeId newParentId = n.getParentId();
                    if (newParentId != null && !oldParentId.equals(newParentId) && !n.isShareable()) {
                        NodeState oldParent;
                        Path oldPath = this.getZombiePath(n.getNodeId(), hmgr);
                        try {
                            oldParent = (NodeState)changes.get(oldParentId);
                        }
                        catch (NoSuchItemStateException e) {
                            oldParent = (NodeState)stateMgr.getItemState(oldParentId);
                        }
                        if (oldParent != null) {
                            NodeTypeImpl oldParentNodeType = this.getNodeType(oldParent, this.session);
                            this.events.add(EventState.childNodeRemoved(oldParentId, this.getParent(oldPath), n.getNodeId(), oldPath.getLastElement(), oldParentNodeType.getQName(), oldParent.getMixinTypeNames(), (Session)this.session));
                        } else {
                            log.error("The old parent (node id " + oldParentId + ") of a moved node (old path " + oldPath + ") is no longer available." + " No REMOVE event generated!");
                        }
                        NodeState newParent = (NodeState)changes.get(newParentId);
                        NodeTypeImpl newParentNodeType = this.getNodeType(newParent, this.session);
                        Set<Name> mixins3 = newParent.getMixinTypeNames();
                        Path newPath = this.getPath(n.getNodeId(), hmgr);
                        this.events.add(EventState.childNodeAdded(newParentId, this.getParent(newPath), n.getNodeId(), newPath.getLastElement(), newParentNodeType.getQName(), mixins3, (Session)this.session));
                        this.events.add(EventState.nodeMovedWithInfo(newParentId, newPath, n.getNodeId(), oldPath, newParentNodeType.getQName(), mixins3, (Session)this.session, false));
                    } else {
                        NodeState parent2 = null;
                        try {
                            if (state.getParentId() != null) {
                                parent2 = (NodeState)changes.get(state.getParentId());
                            }
                        }
                        catch (NoSuchItemStateException e) {
                            String msg = "Parent of node " + state.getId() + " is deleted.";
                            log.error(msg);
                            throw new ItemStateException(msg, e);
                        }
                        if (parent2 != null) {
                            ChildNodeEntry moved = null;
                            for (ChildNodeEntry child : parent2.getRemovedChildNodeEntries()) {
                                if (!child.getId().equals(n.getNodeId())) continue;
                                moved = child;
                            }
                            if (moved != null) {
                                Path oldPath;
                                NodeTypeImpl nodeType3 = this.getNodeType(parent2, this.session);
                                Set<Name> mixins4 = parent2.getMixinTypeNames();
                                Path newPath = this.getPath(state.getId(), hmgr);
                                Path parentPath = this.getParent(newPath);
                                try {
                                    oldPath = moved.getIndex() == 0 ? PathFactoryImpl.getInstance().create(parentPath, moved.getName(), false) : PathFactoryImpl.getInstance().create(parentPath, moved.getName(), moved.getIndex(), false);
                                }
                                catch (RepositoryException e) {
                                    String msg = "Malformed path for item: " + state.getId();
                                    log.error(msg);
                                    throw new ItemStateException(msg, e);
                                }
                                this.events.add(EventState.childNodeRemoved(parent2.getNodeId(), parentPath, n.getNodeId(), oldPath.getLastElement(), nodeType3.getQName(), mixins4, (Session)this.session));
                                this.events.add(EventState.childNodeAdded(parent2.getNodeId(), parentPath, n.getNodeId(), newPath.getLastElement(), nodeType3.getQName(), mixins4, (Session)this.session));
                                this.events.add(EventState.nodeMovedWithInfo(parent2.getNodeId(), newPath, n.getNodeId(), oldPath, nodeType3.getQName(), mixins4, (Session)this.session, false));
                            }
                        }
                    }
                }
                List<ChildNodeEntry> reordered = n.getReorderedChildNodeEntries();
                nodeType2 = this.getNodeType(n, this.session);
                mixins2 = n.getMixinTypeNames();
                if (reordered.size() > 0) {
                    for (ChildNodeEntry child : reordered) {
                        Path addedElem = this.getPathElement(child);
                        Path parentPath = this.getPath(n.getNodeId(), hmgr);
                        NodeState overlayed = (NodeState)n.getOverlayedState();
                        ChildNodeEntry entry = overlayed.getChildNodeEntry(child.getId());
                        if (entry == null) {
                            throw new ItemStateException("Unable to retrieve old child index for item: " + child.getId());
                        }
                        Path removedElem = this.getPathElement(entry);
                        this.events.add(EventState.childNodeRemoved(n.getNodeId(), parentPath, child.getId(), removedElem, nodeType2.getQName(), mixins2, (Session)this.session));
                        this.events.add(EventState.childNodeAdded(n.getNodeId(), parentPath, child.getId(), addedElem, nodeType2.getQName(), mixins2, (Session)this.session));
                        List<ChildNodeEntry> cne = n.getChildNodeEntries();
                        int idx = cne.indexOf(child) + 1;
                        Path beforeElem = null;
                        if (idx < cne.size()) {
                            beforeElem = this.getPathElement(cne.get(idx));
                        }
                        this.events.add(EventState.nodeReordered(n.getNodeId(), parentPath, child.getId(), addedElem, removedElem, beforeElem, nodeType2.getQName(), mixins2, (Session)this.session, false));
                    }
                }
                this.createShareableNodeEvents(n, changes, hmgr, stateMgr);
                continue;
            }
            Path path2 = this.getPath(state.getId(), hmgr);
            parent = (NodeState)stateMgr.getItemState(state.getParentId());
            nodeType2 = this.getNodeType(parent, this.session);
            mixins2 = parent.getMixinTypeNames();
            this.events.add(EventState.propertyChanged(state.getParentId(), this.getParent(path2), path2.getLastElement(), nodeType2.getQName(), mixins2, (Session)this.session));
        }
        for (ItemState state : changes.deletedStates()) {
            if (state.isNode()) {
                n = (NodeState)state;
                parent = (NodeState)stateMgr.getItemState(n.getParentId());
                nodeType2 = this.getNodeType(parent, this.session);
                mixins2 = parent.getMixinTypeNames();
                Path path3 = this.getZombiePath(state.getId(), hmgr);
                this.events.add(EventState.childNodeRemoved(n.getParentId(), this.getParent(path3), n.getNodeId(), path3.getLastElement(), nodeType2.getQName(), mixins2, (Session)this.session));
                this.createShareableNodeEvents(n, changes, hmgr, stateMgr);
                continue;
            }
            try {
                n = (NodeState)changes.get(state.getParentId());
                nodeType = this.getNodeType(n, this.session);
                mixins = n.getMixinTypeNames();
                path = this.getZombiePath(state.getId(), hmgr);
                this.events.add(EventState.propertyRemoved(state.getParentId(), this.getParent(path), path.getLastElement(), nodeType.getQName(), mixins, (Session)this.session));
            }
            catch (NoSuchItemStateException e) {}
        }
        for (ItemState state : changes.addedStates()) {
            if (state.isNode()) {
                n = (NodeState)state;
                NodeId parentId = n.getParentId();
                NodeState parent3 = (NodeState)changes.get(parentId);
                if (parent3 == null) {
                    String msg = "Parent " + parentId + " must be changed as well.";
                    log.error(msg);
                    throw new ItemStateException(msg);
                }
                NodeTypeImpl nodeType4 = this.getNodeType(parent3, this.session);
                Set<Name> mixins5 = parent3.getMixinTypeNames();
                Path path4 = this.getPath(n.getNodeId(), hmgr);
                this.events.add(EventState.childNodeAdded(parentId, this.getParent(path4), n.getNodeId(), path4.getLastElement(), nodeType4.getQName(), mixins5, (Session)this.session));
                this.createShareableNodeEvents(n, changes, hmgr, stateMgr);
                continue;
            }
            n = (NodeState)changes.get(state.getParentId());
            if (n == null) {
                String msg = "Node " + state.getParentId() + " must be changed as well.";
                log.error(msg);
                throw new ItemStateException(msg);
            }
            nodeType = this.getNodeType(n, this.session);
            mixins = n.getMixinTypeNames();
            path = this.getPath(state.getId(), hmgr);
            this.events.add(EventState.propertyAdded(state.getParentId(), this.getParent(path), path.getLastElement(), nodeType.getQName(), mixins, (Session)this.session));
        }
    }

    public void addAll(Collection<EventState> c) {
        this.events.addAll(c);
    }

    public void prepare() {
        this.dispatcher.prepareEvents(this);
    }

    public void prepareDeleted(ChangeLog changes) {
        this.dispatcher.prepareDeleted(this, changes);
    }

    public void dispatch() {
        this.dispatcher.dispatchEvents(this);
    }

    public Path getPathPrefix() {
        return this.pathPrefix;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    Iterator<EventState> iterator() {
        return this.events.iterator();
    }

    public List<EventState> getEvents() {
        return Collections.unmodifiableList(this.events);
    }

    public int size() {
        return this.events.size();
    }

    public SessionImpl getSession() {
        return this.session;
    }

    public String getUserData() {
        return this.userData;
    }

    public void setUserData(String userData) {
        this.userData = userData;
    }

    private void createShareableNodeEvents(NodeState n, ChangeLog changes, ChangeLogBasedHierarchyMgr hmgr, ItemStateManager stateMgr) throws ItemStateException {
        if (n.isShareable()) {
            EventState es;
            Name ntName;
            NodeState parent;
            for (NodeId parentId : n.getAddedShares()) {
                if (n.getParentId().equals(parentId)) continue;
                parent = (NodeState)changes.get(parentId);
                if (parent == null) {
                    parent = (NodeState)stateMgr.getItemState(parentId);
                }
                ntName = this.getNodeType(parent, this.session).getQName();
                es = EventState.childNodeAdded(parentId, this.getPath(parentId, hmgr), n.getNodeId(), this.getNameElement(n.getNodeId(), parentId, hmgr), ntName, parent.getMixinTypeNames(), (Session)this.session);
                es.setShareableNode(true);
                this.events.add(es);
            }
            for (NodeId parentId : n.getRemovedShares()) {
                if (n.getParentId().equals(parentId)) continue;
                parent = null;
                try {
                    parent = (NodeState)changes.get(parentId);
                }
                catch (NoSuchItemStateException e) {
                    // empty catch block
                }
                if (parent == null) {
                    parent = (NodeState)stateMgr.getItemState(parentId);
                }
                ntName = this.getNodeType(parent, this.session).getQName();
                es = EventState.childNodeRemoved(parentId, this.getZombiePath(parentId, hmgr), n.getNodeId(), this.getZombieNameElement(n.getNodeId(), parentId, hmgr), ntName, parent.getMixinTypeNames(), (Session)this.session);
                es.setShareableNode(true);
                this.events.add(es);
            }
        }
    }

    private NodeTypeImpl getNodeType(NodeState node, SessionImpl session) throws ItemStateException {
        try {
            return session.getNodeTypeManager().getNodeType(node.getNodeTypeName());
        }
        catch (Exception e) {
            String msg = node == null ? "Node state is null" : "Item " + node.getNodeId() + " has unknown node type: " + node.getNodeTypeName();
            log.error(msg);
            throw new ItemStateException(msg, e);
        }
    }

    private Path getParent(Path p) throws ItemStateException {
        try {
            return p.getAncestor(1);
        }
        catch (RepositoryException e) {
            String msg = "Unable to resolve parent for path: " + p;
            log.error(msg);
            throw new ItemStateException(msg, e);
        }
    }

    private Path getPath(ItemId itemId, HierarchyManager hmgr) throws ItemStateException {
        try {
            return this.prefixPath(hmgr.getPath(itemId));
        }
        catch (RepositoryException e) {
            String msg = "Unable to resolve path for item: " + itemId;
            log.error(msg);
            throw new ItemStateException(msg, e);
        }
    }

    private Path getNameElement(NodeId nodeId, NodeId parentId, HierarchyManager hmgr) throws ItemStateException {
        try {
            Name name = hmgr.getName(nodeId, parentId);
            return PathFactoryImpl.getInstance().create(name);
        }
        catch (RepositoryException e) {
            String msg = "Unable to get name for node with id: " + nodeId;
            throw new ItemStateException(msg, e);
        }
    }

    private Path getZombieNameElement(NodeId nodeId, NodeId parentId, ChangeLogBasedHierarchyMgr hmgr) throws ItemStateException {
        try {
            Name name = hmgr.getZombieName(nodeId, parentId);
            return PathFactoryImpl.getInstance().create(name);
        }
        catch (RepositoryException e) {
            String msg = "Unable to resolve zombie name for item: " + nodeId;
            log.error(msg);
            throw new ItemStateException(msg, e);
        }
    }

    private Path getZombiePath(ItemId itemId, ChangeLogBasedHierarchyMgr hmgr) throws ItemStateException {
        try {
            return this.prefixPath(hmgr.getZombiePath(itemId));
        }
        catch (RepositoryException e) {
            String msg = "Unable to resolve zombie path for item: " + itemId;
            log.error(msg);
            throw new ItemStateException(msg, e);
        }
    }

    private Path prefixPath(Path p) throws RepositoryException {
        if (this.pathPrefix == null) {
            return p;
        }
        PathBuilder builder = new PathBuilder(this.pathPrefix.getElements());
        Path.Element[] elements = p.getElements();
        for (int i = 0; i < elements.length; ++i) {
            if (elements[i].denotesRoot()) continue;
            builder.addLast(elements[i]);
        }
        return builder.getPath();
    }

    private Path getPathElement(ChildNodeEntry entry) {
        Name name = entry.getName();
        int index = entry.getIndex() != 1 ? entry.getIndex() : 0;
        return PathFactoryImpl.getInstance().create(name, index);
    }

    public String getCommonPath() {
        return EventState.getCommonPath(this.events, this.session);
    }
}

