/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.jcr;

import javax.jcr.RepositoryException;
import javax.jcr.nodetype.ItemDefinition;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeManager;

abstract class MockItemDefinition
implements ItemDefinition {
    protected String name;
    protected boolean autoCreated;
    protected boolean mandatory;
    protected int opv;
    protected boolean protectedStatus;
    protected String declaringNodeTypeName;
    protected NodeTypeManager ntMgr;

    protected MockItemDefinition(String declaringNodeTypeName, NodeTypeManager ntMgr) {
        this.declaringNodeTypeName = declaringNodeTypeName;
        this.ntMgr = ntMgr;
    }

    public NodeType getDeclaringNodeType() {
        NodeType nt = null;
        if (this.ntMgr != null && this.declaringNodeTypeName != null) {
            try {
                nt = this.ntMgr.getNodeType(this.declaringNodeTypeName);
            }
            catch (RepositoryException e) {
                throw new RuntimeException("Getting declared node type failed.", e);
            }
        }
        return nt;
    }

    public String getName() {
        return this.name;
    }

    public boolean isAutoCreated() {
        return this.autoCreated;
    }

    public boolean isMandatory() {
        return this.mandatory;
    }

    public int getOnParentVersion() {
        return this.opv;
    }

    public boolean isProtected() {
        return this.protectedStatus;
    }
}

