/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming.runtime;

import java.io.Serializable;
import java.util.UUID;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.sql.RuntimeConfig;
import org.apache.spark.sql.catalyst.plans.logical.EventTimeWatermark;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.streaming.operators.stateful.EventTimeWatermarkExec;
import org.apache.spark.sql.execution.streaming.runtime.MultipleWatermarkPolicy;
import org.apache.spark.sql.execution.streaming.runtime.WatermarkTracker$;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Some;
import scala.StringContext;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0005ea\u0001B\t\u0013\u0001\u0005B\u0001B\f\u0001\u0003\u0002\u0003\u0006Ia\f\u0005\tg\u0001\u0011\t\u0011)A\u0005i!)a\b\u0001C\u0001\u007f!91\t\u0001b\u0001\n\u0013!\u0005BB.\u0001A\u0003%Q\tC\u0004]\u0001\u0001\u0007I\u0011B/\t\u000fy\u0003\u0001\u0019!C\u0005?\"1Q\r\u0001Q!\naCQA\u001a\u0001\u0005\u0002\u001dDQA\u001b\u0001\u0005\u0002-DQA\u001d\u0001\u0005\u0002uCaa\u001d\u0001\u0005\u0002a!xAB@\u0013\u0011\u0003\t\tA\u0002\u0004\u0012%!\u0005\u00111\u0001\u0005\u0007}9!\t!!\u0002\t\u000f\u0005\u001da\u0002\"\u0001\u0002\n\t\u0001r+\u0019;fe6\f'o\u001b+sC\u000e\\WM\u001d\u0006\u0003'Q\tqA];oi&lWM\u0003\u0002\u0016-\u0005I1\u000f\u001e:fC6Lgn\u001a\u0006\u0003/a\t\u0011\"\u001a=fGV$\u0018n\u001c8\u000b\u0005eQ\u0012aA:rY*\u00111\u0004H\u0001\u0006gB\f'o\u001b\u0006\u0003;y\ta!\u00199bG\",'\"A\u0010\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001\u0011\u0003\u0006\u0005\u0002$M5\tAEC\u0001&\u0003\u0015\u00198-\u00197b\u0013\t9CE\u0001\u0004B]f\u0014VM\u001a\t\u0003S1j\u0011A\u000b\u0006\u0003Wi\t\u0001\"\u001b8uKJt\u0017\r\\\u0005\u0003[)\u0012q\u0001T8hO&tw-\u0001\u0004q_2L7-\u001f\t\u0003aEj\u0011AE\u0005\u0003eI\u0011q#T;mi&\u0004H.Z,bi\u0016\u0014X.\u0019:l!>d\u0017nY=\u0002\u0017%t\u0017\u000e^5bYBc\u0017M\u001c\t\u0003kqj\u0011A\u000e\u0006\u0003oa\nq\u0001\\8hS\u000e\fGN\u0003\u0002:u\u0005)\u0001\u000f\\1og*\u00111\bG\u0001\tG\u0006$\u0018\r\\=ti&\u0011QH\u000e\u0002\f\u0019><\u0017nY1m!2\fg.\u0001\u0004=S:LGO\u0010\u000b\u0004\u0001\u0006\u0013\u0005C\u0001\u0019\u0001\u0011\u0015q3\u00011\u00010\u0011\u0015\u00194\u00011\u00015\u0003Yy\u0007/\u001a:bi>\u0014Hk\\,bi\u0016\u0014X.\u0019:l\u001b\u0006\u0004X#A#\u0011\t\u0019[U*V\u0007\u0002\u000f*\u0011\u0001*S\u0001\b[V$\u0018M\u00197f\u0015\tQE%\u0001\u0006d_2dWm\u0019;j_:L!\u0001T$\u0003\u00075\u000b\u0007\u000f\u0005\u0002O'6\tqJ\u0003\u0002Q#\u0006!Q\u000f^5m\u0015\u0005\u0011\u0016\u0001\u00026bm\u0006L!\u0001V(\u0003\tU+\u0016\n\u0012\t\u0004GYC\u0016BA,%\u0005\u0019y\u0005\u000f^5p]B\u00111%W\u0005\u00035\u0012\u0012A\u0001T8oO\u00069r\u000e]3sCR|'\u000fV8XCR,'/\\1sW6\u000b\u0007\u000fI\u0001\u0012O2|'-\u00197XCR,'/\\1sW6\u001bX#\u0001-\u0002+\u001ddwNY1m/\u0006$XM]7be.l5o\u0018\u0013fcR\u0011\u0001m\u0019\t\u0003G\u0005L!A\u0019\u0013\u0003\tUs\u0017\u000e\u001e\u0005\bI\u001e\t\t\u00111\u0001Y\u0003\rAH%M\u0001\u0013O2|'-\u00197XCR,'/\\1sW6\u001b\b%\u0001\u0007tKR<\u0016\r^3s[\u0006\u00148\u000e\u0006\u0002aQ\")\u0011.\u0003a\u00011\u0006qa.Z<XCR,'/\\1sW6\u001b\u0018aD;qI\u0006$XmV1uKJl\u0017M]6\u0015\u0005\u0001d\u0007\"B7\u000b\u0001\u0004q\u0017\u0001D3yK\u000e,H/\u001a3QY\u0006t\u0007CA8q\u001b\u00051\u0012BA9\u0017\u0005%\u0019\u0006/\u0019:l!2\fg.\u0001\tdkJ\u0014XM\u001c;XCR,'/\\1sW\u0006aq/\u0019;fe6\f'o['baV\tQ\u000f\u0005\u0003w{6+fBA<|!\tAH%D\u0001z\u0015\tQ\b%\u0001\u0004=e>|GOP\u0005\u0003y\u0012\na\u0001\u0015:fI\u00164\u0017B\u0001'\u007f\u0015\taH%\u0001\tXCR,'/\\1sWR\u0013\u0018mY6feB\u0011\u0001GD\n\u0003\u001d\t\"\"!!\u0001\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u000b\u0001\u000bY!a\u0006\t\u000f\u00055\u0001\u00031\u0001\u0002\u0010\u0005!1m\u001c8g!\u0011\t\t\"a\u0005\u000e\u0003aI1!!\u0006\u0019\u00055\u0011VO\u001c;j[\u0016\u001cuN\u001c4jO\")1\u0007\u0005a\u0001i\u0001")
public class WatermarkTracker
implements Logging {
    private final MultipleWatermarkPolicy policy;
    private final Map<UUID, Option<Object>> operatorToWatermarkMap;
    private long globalWatermarkMs;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static WatermarkTracker apply(RuntimeConfig conf, LogicalPlan initialPlan) {
        return WatermarkTracker$.MODULE$.apply(conf, initialPlan);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(java.util.Map<String, String> context, Function0<BoxedUnit> body2) {
        Logging.withLogContext$((Logging)this, context, body2);
    }

    public MDC MDC(LogKey key, Object value) {
        return Logging.MDC$((Logging)this, (LogKey)key, (Object)value);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void logBasedOnLevel(Level level, Function0<MessageWithContext> f) {
        Logging.logBasedOnLevel$((Logging)this, (Level)level, f);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private Map<UUID, Option<Object>> operatorToWatermarkMap() {
        return this.operatorToWatermarkMap;
    }

    private long globalWatermarkMs() {
        return this.globalWatermarkMs;
    }

    private void globalWatermarkMs_$eq(long x$1) {
        this.globalWatermarkMs = x$1;
    }

    public synchronized void setWatermark(long newWatermarkMs) {
        this.globalWatermarkMs_$eq(newWatermarkMs);
    }

    public synchronized void updateWatermark(SparkPlan executedPlan) {
        Seq watermarkOperators = executedPlan.collect((PartialFunction)new Serializable(null){
            private static final long serialVersionUID = 0L;

            public final <A1 extends SparkPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof EventTimeWatermarkExec) {
                    EventTimeWatermarkExec eventTimeWatermarkExec = (EventTimeWatermarkExec)A1;
                    return (B1)eventTimeWatermarkExec;
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(SparkPlan x1) {
                SparkPlan sparkPlan = x1;
                return sparkPlan instanceof EventTimeWatermarkExec;
            }
        });
        if (watermarkOperators.isEmpty()) {
            return;
        }
        watermarkOperators.foreach((Function1 & Serializable)x0$1 -> {
            EventTimeWatermarkExec eventTimeWatermarkExec = x0$1;
            if (eventTimeWatermarkExec.eventTimeStats().value().count() > 0L) {
                this.logDebug((Function0<String>)(Function0 & Serializable)() -> "Observed event time stats " + eventTimeWatermarkExec.nodeId() + ": " + eventTimeWatermarkExec.eventTimeStats().value());
                if (!this.operatorToWatermarkMap().isDefinedAt((Object)eventTimeWatermarkExec.nodeId())) {
                    throw new IllegalStateException("Unknown watermark node ID: " + eventTimeWatermarkExec.nodeId() + ", known IDs: " + this.operatorToWatermarkMap().keys().mkString("[", ",", "]"));
                }
                long newWatermarkMs = eventTimeWatermarkExec.eventTimeStats().value().max() - eventTimeWatermarkExec.delayMs();
                Option prevWatermarkMs = (Option)this.operatorToWatermarkMap().apply((Object)eventTimeWatermarkExec.nodeId());
                if (prevWatermarkMs.isEmpty() || newWatermarkMs > BoxesRunTime.unboxToLong((Object)prevWatermarkMs.get())) {
                    return this.operatorToWatermarkMap().put((Object)eventTimeWatermarkExec.nodeId(), (Object)new Some((Object)BoxesRunTime.boxToLong((long)newWatermarkMs)));
                }
                return BoxedUnit.UNIT;
            }
            if (!this.operatorToWatermarkMap().isDefinedAt((Object)eventTimeWatermarkExec.nodeId())) {
                throw new IllegalStateException("Unknown watermark node ID: " + eventTimeWatermarkExec.nodeId() + ", known IDs: " + this.operatorToWatermarkMap().keys().mkString("[", ",", "]"));
            }
            return BoxedUnit.UNIT;
        });
        long chosenGlobalWatermark = this.policy.chooseGlobalWatermark((Seq<Object>)((IterableOnceOps)this.operatorToWatermarkMap().values().map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToLong((long)WatermarkTracker.$anonfun$updateWatermark$3(x$1)))).toSeq());
        if (chosenGlobalWatermark > this.globalWatermarkMs()) {
            this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Updating event-time watermark from "}))).log((Seq)Nil$.MODULE$).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", " "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.GLOBAL_WATERMARK, BoxesRunTime.boxToLong((long)this.globalWatermarkMs()))}))).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"to ", " ms"}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.CHOSEN_WATERMARK, BoxesRunTime.boxToLong((long)chosenGlobalWatermark))})))));
            this.globalWatermarkMs_$eq(chosenGlobalWatermark);
            return;
        }
        this.logDebug((Function0<String>)(Function0 & Serializable)() -> "Event time watermark didn't move: " + chosenGlobalWatermark + " < " + this.globalWatermarkMs());
    }

    public synchronized long currentWatermark() {
        return this.globalWatermarkMs();
    }

    public synchronized scala.collection.immutable.Map<UUID, Option<Object>> watermarkMap() {
        return this.operatorToWatermarkMap().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public static final /* synthetic */ long $anonfun$updateWatermark$3(Option x$1) {
        return BoxesRunTime.unboxToLong((Object)x$1.getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L));
    }

    /*
     * WARNING - void declaration
     */
    public WatermarkTracker(MultipleWatermarkPolicy policy, LogicalPlan initialPlan) {
        void var3_3;
        this.policy = policy;
        Logging.$init$((Logging)this);
        HashMap map = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        Seq watermarkOperators = initialPlan.collect((PartialFunction)new Serializable(null){
            private static final long serialVersionUID = 0L;

            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof EventTimeWatermark) {
                    EventTimeWatermark eventTimeWatermark = (EventTimeWatermark)A1;
                    return (B1)eventTimeWatermark;
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(LogicalPlan x1) {
                LogicalPlan logicalPlan2 = x1;
                return logicalPlan2 instanceof EventTimeWatermark;
            }
        });
        watermarkOperators.foreach((Function1 & Serializable)op -> map.put((Object)op.nodeId(), (Object)None$.MODULE$));
        this.operatorToWatermarkMap = var3_3;
        this.globalWatermarkMs = 0L;
    }
}

