/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.analysis.resolver;

import java.io.Serializable;
import org.apache.spark.QueryContext;
import org.apache.spark.sql.catalyst.SQLConfHelper;
import org.apache.spark.sql.catalyst.analysis.resolver.CoercesExpressionTypes;
import org.apache.spark.sql.catalyst.analysis.resolver.ExpressionResolver;
import org.apache.spark.sql.catalyst.analysis.resolver.ExpressionTreeTraversal;
import org.apache.spark.sql.catalyst.analysis.resolver.ExpressionTreeTraversalStack;
import org.apache.spark.sql.catalyst.analysis.resolver.ResolvesExpressionChildren;
import org.apache.spark.sql.catalyst.analysis.resolver.TimezoneAwareExpressionResolver$;
import org.apache.spark.sql.catalyst.analysis.resolver.TreeNodeResolver;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.DefaultStringProducingExpression;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.QuaternaryExpression;
import org.apache.spark.sql.catalyst.expressions.TernaryExpression;
import org.apache.spark.sql.catalyst.expressions.TimeZoneAwareExpression;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.errors.DataTypeErrorsBase;
import org.apache.spark.sql.errors.QueryErrorsBase;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function0;
import scala.Function1;
import scala.Tuple2;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u000554A\u0001D\u0007\u00019!Aa\u0007\u0001B\u0001B\u0003%q\u0007C\u0003;\u0001\u0011\u00051\bC\u0004?\u0001\t\u0007I\u0011B \t\r\r\u0003\u0001\u0015!\u0003A\u0011\u0015!\u0005\u0001\"\u0011F\u0011\u0015A\u0005\u0001\"\u0003J\u0011\u0015a\u0006\u0001\"\u0003^\u000f\u0015\u0019W\u0002#\u0001e\r\u0015aQ\u0002#\u0001f\u0011\u0015Q\u0014\u0002\"\u0001g\u0011\u00159\u0017\u0002\"\u0001i\u0005}!\u0016.\\3{_:,\u0017i^1sK\u0016C\bO]3tg&|gNU3t_24XM\u001d\u0006\u0003\u001d=\t\u0001B]3t_24XM\u001d\u0006\u0003!E\t\u0001\"\u00198bYf\u001c\u0018n\u001d\u0006\u0003%M\t\u0001bY1uC2L8\u000f\u001e\u0006\u0003)U\t1a]9m\u0015\t1r#A\u0003ta\u0006\u00148N\u0003\u0002\u00193\u00051\u0011\r]1dQ\u0016T\u0011AG\u0001\u0004_J<7\u0001A\n\u0006\u0001u\u0019\u0003g\r\t\u0003=\u0005j\u0011a\b\u0006\u0002A\u0005)1oY1mC&\u0011!e\b\u0002\u0007\u0003:L(+\u001a4\u0011\t\u0011*s%L\u0007\u0002\u001b%\u0011a%\u0004\u0002\u0011)J,WMT8eKJ+7o\u001c7wKJ\u0004\"\u0001K\u0016\u000e\u0003%R!AK\t\u0002\u0017\u0015D\bO]3tg&|gn]\u0005\u0003Y%\u0012q\u0003V5nKj{g.Z!xCJ,W\t\u001f9sKN\u001c\u0018n\u001c8\u0011\u0005!r\u0013BA\u0018*\u0005))\u0005\u0010\u001d:fgNLwN\u001c\t\u0003IEJ!AM\u0007\u00035I+7o\u001c7wKN,\u0005\u0010\u001d:fgNLwN\\\"iS2$'/\u001a8\u0011\u0005\u0011\"\u0014BA\u001b\u000e\u0005Y\u0019u.\u001a:dKN,\u0005\u0010\u001d:fgNLwN\u001c+za\u0016\u001c\u0018AE3yaJ,7o]5p]J+7o\u001c7wKJ\u0004\"\u0001\n\u001d\n\u0005ej!AE#yaJ,7o]5p]J+7o\u001c7wKJ\fa\u0001P5oSRtDC\u0001\u001f>!\t!\u0003\u0001C\u00037\u0005\u0001\u0007q'\u0001\u0006ue\u00064XM]:bYN,\u0012\u0001\u0011\t\u0003I\u0005K!AQ\u0007\u00039\u0015C\bO]3tg&|g\u000e\u0016:fKR\u0013\u0018M^3sg\u0006d7\u000b^1dW\u0006YAO]1wKJ\u001c\u0018\r\\:!\u0003\u001d\u0011Xm]8mm\u0016$\"!\f$\t\u000b\u001d+\u0001\u0019A\u0014\u00029Ut'/Z:pYZ,G\rV5nKj|g.Z#yaJ,7o]5p]\u0006yAO]=D_2d\u0017\r]:f\u0007\u0006\u001cH\u000fF\u0002K\u001b>\u0003\"\u0001K&\n\u00051K#\u0001B\"bgRDQA\u0014\u0004A\u0002)\u000bAaY1ti\")\u0001K\u0002a\u0001#\u0006\u0001B-\u001a4bk2$8i\u001c7mCRLwN\u001c\t\u0003%fs!aU,\u0011\u0005Q{R\"A+\u000b\u0005Y[\u0012A\u0002\u001fs_>$h(\u0003\u0002Y?\u00051\u0001K]3eK\u001aL!AW.\u0003\rM#(/\u001b8h\u0015\tAv$A\ftQ>,H\u000eZ\"pY2\f\u0007o]3J]:,'oQ1tiR\u0019a,\u00192\u0011\u0005yy\u0016B\u00011 \u0005\u001d\u0011un\u001c7fC:DQAT\u0004A\u0002)CQ\u0001U\u0004A\u0002E\u000bq\u0004V5nKj|g.Z!xCJ,W\t\u001f9sKN\u001c\u0018n\u001c8SKN|GN^3s!\t!\u0013b\u0005\u0002\n;Q\tA-A\bsKN|GN^3US6,'p\u001c8f)\ri\u0013n\u001b\u0005\u0006U.\u0001\r!L\u0001\u000bKb\u0004(/Z:tS>t\u0007\"\u00027\f\u0001\u0004\t\u0016A\u0003;j[\u0016TvN\\3JI\u0002")
public class TimezoneAwareExpressionResolver
implements TreeNodeResolver<TimeZoneAwareExpression, Expression>,
ResolvesExpressionChildren,
CoercesExpressionTypes {
    private final ExpressionResolver expressionResolver;
    private final ExpressionTreeTraversalStack traversals;
    private Seq<Function1<Expression, Expression>> ansiTransformations;
    private Seq<Function1<Expression, Expression>> nonAnsiTransformations;

    public static Expression resolveTimezone(Expression expression, String timeZoneId) {
        return TimezoneAwareExpressionResolver$.MODULE$.resolveTimezone(expression, timeZoneId);
    }

    @Override
    public Expression coerceExpressionTypes(Expression expression, ExpressionTreeTraversal expressionTreeTraversal) {
        return CoercesExpressionTypes.coerceExpressionTypes$(this, expression, expressionTreeTraversal);
    }

    @Override
    public Expression withResolvedChildren(UnaryExpression unresolvedExpression, Function1<Expression, Expression> resolveChild) {
        return ResolvesExpressionChildren.withResolvedChildren$((ResolvesExpressionChildren)this, unresolvedExpression, resolveChild);
    }

    @Override
    public Expression withResolvedChildren(BinaryExpression unresolvedExpression, Function1<Expression, Expression> resolveChild) {
        return ResolvesExpressionChildren.withResolvedChildren$((ResolvesExpressionChildren)this, unresolvedExpression, resolveChild);
    }

    @Override
    public Expression withResolvedChildren(TernaryExpression unresolvedExpression, Function1<Expression, Expression> resolveChild) {
        return ResolvesExpressionChildren.withResolvedChildren$((ResolvesExpressionChildren)this, unresolvedExpression, resolveChild);
    }

    @Override
    public Expression withResolvedChildren(QuaternaryExpression unresolvedExpression, Function1<Expression, Expression> resolveChild) {
        return ResolvesExpressionChildren.withResolvedChildren$((ResolvesExpressionChildren)this, unresolvedExpression, resolveChild);
    }

    @Override
    public Expression withResolvedChildren(Expression unresolvedExpression, Function1<Expression, Expression> resolveChild) {
        return ResolvesExpressionChildren.withResolvedChildren$((ResolvesExpressionChildren)this, unresolvedExpression, resolveChild);
    }

    @Override
    public String toSQLConfVal(String conf) {
        return QueryErrorsBase.toSQLConfVal$(this, conf);
    }

    @Override
    public String toSQLExpr(Expression e) {
        return QueryErrorsBase.toSQLExpr$(this, e);
    }

    @Override
    public String toSQLValue(Object v, DataType t) {
        return QueryErrorsBase.toSQLValue$(this, v, t);
    }

    @Override
    public String ordinalNumber(int i) {
        return QueryErrorsBase.ordinalNumber$(this, i);
    }

    public String toSQLId(String parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, (String)parts);
    }

    public String toSQLId(Seq<String> parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, parts);
    }

    public String toSQLStmt(String text) {
        return DataTypeErrorsBase.toSQLStmt$((DataTypeErrorsBase)this, (String)text);
    }

    public String toSQLConf(String conf) {
        return DataTypeErrorsBase.toSQLConf$((DataTypeErrorsBase)this, (String)conf);
    }

    public String toSQLType(String text) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (String)text);
    }

    public String toSQLType(AbstractDataType t) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (AbstractDataType)t);
    }

    public String toSQLValue(String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (String)value);
    }

    public String toSQLValue(UTF8String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (UTF8String)value);
    }

    public String toSQLValue(short value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (short)value);
    }

    public String toSQLValue(int value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (int)value);
    }

    public String toSQLValue(long value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (long)value);
    }

    public String toSQLValue(float value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (float)value);
    }

    public String toSQLValue(double value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (double)value);
    }

    public String quoteByDefault(String elem) {
        return DataTypeErrorsBase.quoteByDefault$((DataTypeErrorsBase)this, (String)elem);
    }

    public String getSummary(QueryContext sqlContext) {
        return DataTypeErrorsBase.getSummary$((DataTypeErrorsBase)this, (QueryContext)sqlContext);
    }

    public QueryContext[] getQueryContext(QueryContext context) {
        return DataTypeErrorsBase.getQueryContext$((DataTypeErrorsBase)this, (QueryContext)context);
    }

    public String toDSOption(String option) {
        return DataTypeErrorsBase.toDSOption$((DataTypeErrorsBase)this, (String)option);
    }

    @Override
    public SQLConf conf() {
        return SQLConfHelper.conf$(this);
    }

    @Override
    public <T> T withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<T> f) {
        return (T)SQLConfHelper.withSQLConf$(this, pairs, f);
    }

    @Override
    public Seq<Function1<Expression, Expression>> ansiTransformations() {
        return this.ansiTransformations;
    }

    @Override
    public Seq<Function1<Expression, Expression>> nonAnsiTransformations() {
        return this.nonAnsiTransformations;
    }

    @Override
    public void org$apache$spark$sql$catalyst$analysis$resolver$CoercesExpressionTypes$_setter_$ansiTransformations_$eq(Seq<Function1<Expression, Expression>> x$1) {
        this.ansiTransformations = x$1;
    }

    @Override
    public void org$apache$spark$sql$catalyst$analysis$resolver$CoercesExpressionTypes$_setter_$nonAnsiTransformations_$eq(Seq<Function1<Expression, Expression>> x$1) {
        this.nonAnsiTransformations = x$1;
    }

    private ExpressionTreeTraversalStack traversals() {
        return this.traversals;
    }

    @Override
    public Expression resolve(TimeZoneAwareExpression unresolvedTimezoneExpression) {
        Expression expressionWithResolvedChildren = this.withResolvedChildren((Expression)((Object)unresolvedTimezoneExpression), (Function1<Expression, Expression>)(Function1 & Serializable)unresolvedExpression -> $this.expressionResolver.resolve((Expression)unresolvedExpression));
        Expression expressionWithResolvedChildrenAndTimeZone = TimezoneAwareExpressionResolver$.MODULE$.resolveTimezone(expressionWithResolvedChildren, this.traversals().current().sessionLocalTimeZone());
        Expression expression = this.coerceExpressionTypes(expressionWithResolvedChildrenAndTimeZone, this.traversals().current());
        if (expression instanceof Cast) {
            Cast cast = (Cast)expression;
            if (this.traversals().current().defaultCollation().isDefined()) {
                return this.tryCollapseCast(cast, (String)this.traversals().current().defaultCollation().get());
            }
        }
        return expression;
    }

    private Cast tryCollapseCast(Cast cast, String defaultCollation) {
        Expression expression = cast.child();
        if (expression instanceof Cast) {
            Cast cast2 = (Cast)expression;
            if (this.shouldCollapseInnerCast(cast, defaultCollation)) {
                return cast.copy(cast2.child(), cast.copy$default$2(), cast.copy$default$3(), cast.copy$default$4());
            }
        }
        return cast;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean shouldCollapseInnerCast(Cast cast, String defaultCollation) {
        StringType stringType = StringType$.MODULE$.apply(defaultCollation);
        StringType$ stringType$ = StringType$.MODULE$;
        if (stringType == null) {
            if (stringType$ == null) return false;
        } else if (stringType.equals(stringType$)) return false;
        Expression expression = cast.child();
        if (!(expression instanceof Cast)) return false;
        Cast cast2 = (Cast)expression;
        DataType innerDataType = cast2.dataType();
        if (!(cast2.child() instanceof DefaultStringProducingExpression)) return false;
        DataType dataType = cast.dataType();
        DataType dataType2 = innerDataType;
        if (dataType != null) {
            if (!dataType.equals(dataType2)) return false;
            return true;
        }
        if (dataType2 == null) return true;
        return false;
    }

    public TimezoneAwareExpressionResolver(ExpressionResolver expressionResolver) {
        this.expressionResolver = expressionResolver;
        SQLConfHelper.$init$(this);
        DataTypeErrorsBase.$init$((DataTypeErrorsBase)this);
        QueryErrorsBase.$init$(this);
        ResolvesExpressionChildren.$init$(this);
        CoercesExpressionTypes.$init$(this);
        this.traversals = expressionResolver.getExpressionTreeTraversals();
        Statics.releaseFence();
    }
}

