/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.util;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.SQLConfHelper;
import org.apache.spark.sql.catalyst.analysis.CastSupport;
import org.apache.spark.sql.catalyst.analysis.ResolvedInlineTable;
import org.apache.spark.sql.catalyst.analysis.TypeCoercion$;
import org.apache.spark.sql.catalyst.analysis.UnresolvedInlineTable;
import org.apache.spark.sql.catalyst.analysis.package$;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.AliasHelper;
import org.apache.spark.sql.catalyst.expressions.AttributeMap;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.EvalHelper;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.optimizer.EvalInlineTables$;
import org.apache.spark.sql.catalyst.plans.logical.Aggregate;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Project;
import org.apache.spark.sql.catalyst.trees.TreePattern$;
import org.apache.spark.sql.catalyst.types.DataTypeUtils$;
import org.apache.spark.sql.catalyst.util.TypeUtils$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class EvaluateUnresolvedInlineTable$
implements SQLConfHelper,
AliasHelper,
EvalHelper,
CastSupport {
    public static final EvaluateUnresolvedInlineTable$ MODULE$ = new EvaluateUnresolvedInlineTable$();

    static {
        SQLConfHelper.$init$(MODULE$);
        AliasHelper.$init$(MODULE$);
        EvalHelper.$init$(MODULE$);
        CastSupport.$init$(MODULE$);
    }

    @Override
    public Cast cast(Expression child, DataType dataType) {
        return CastSupport.cast$(this, child, dataType);
    }

    @Override
    public Expression prepareForEval(Expression e) {
        return EvalHelper.prepareForEval$(this, e);
    }

    @Override
    public AttributeMap<Alias> getAliasMap(Project plan2) {
        return AliasHelper.getAliasMap$((AliasHelper)this, plan2);
    }

    @Override
    public AttributeMap<Alias> getAliasMap(Aggregate plan2) {
        return AliasHelper.getAliasMap$((AliasHelper)this, plan2);
    }

    @Override
    public AttributeMap<Alias> getAliasMap(Iterable<NamedExpression> exprs) {
        return AliasHelper.getAliasMap$((AliasHelper)this, exprs);
    }

    @Override
    public Expression replaceAlias(Expression expr, AttributeMap<Alias> aliasMap) {
        return AliasHelper.replaceAlias$(this, expr, aliasMap);
    }

    @Override
    public NamedExpression replaceAliasButKeepName(NamedExpression expr, AttributeMap<Alias> aliasMap) {
        return AliasHelper.replaceAliasButKeepName$(this, expr, aliasMap);
    }

    @Override
    public Expression trimAliases(Expression e) {
        return AliasHelper.trimAliases$(this, e);
    }

    @Override
    public <T extends Expression> T trimNonTopLevelAliases(T e) {
        return (T)AliasHelper.trimNonTopLevelAliases$(this, e);
    }

    @Override
    public SQLConf conf() {
        return SQLConfHelper.conf$(this);
    }

    @Override
    public <T> T withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<T> f) {
        return (T)SQLConfHelper.withSQLConf$(this, pairs, f);
    }

    public LogicalPlan evaluate(UnresolvedInlineTable plan2) {
        if (plan2.expressionsResolved()) {
            return this.evaluateUnresolvedInlineTable(plan2);
        }
        return plan2;
    }

    public LogicalPlan evaluateUnresolvedInlineTable(UnresolvedInlineTable table) {
        this.validateInputDimension(table);
        this.validateInputEvaluable(table);
        ResolvedInlineTable resolvedTable = this.findCommonTypesAndCast(table);
        return this.earlyEvalIfPossible(resolvedTable);
    }

    private LogicalPlan earlyEvalIfPossible(ResolvedInlineTable table) {
        boolean earlyEvalPossible = ((IterableOnceOps)table.rows().flatten(Predef$.MODULE$.$conforms())).forall((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)EvaluateUnresolvedInlineTable$.$anonfun$earlyEvalIfPossible$1(x$1)));
        if (earlyEvalPossible) {
            return EvalInlineTables$.MODULE$.eval(table);
        }
        return table;
    }

    public void validateInputDimension(UnresolvedInlineTable table) {
        if (table.rows().nonEmpty()) {
            int numCols = table.names().size();
            ((IterableOnceOps)table.rows().zipWithIndex()).foreach((Function1 & Serializable)x0$1 -> {
                EvaluateUnresolvedInlineTable$.$anonfun$validateInputDimension$1(numCols, table, x0$1);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    public void validateInputEvaluable(UnresolvedInlineTable table) {
        table.rows().foreach((Function1 & Serializable)row -> {
            row.foreach((Function1 & Serializable)e -> {
                EvaluateUnresolvedInlineTable$.$anonfun$validateInputEvaluable$2(e);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        });
    }

    public ResolvedInlineTable findCommonTypesAndCast(UnresolvedInlineTable table) {
        Tuple2 tuple2 = ((IterableOps)((IterableOps)((IterableOps)table.rows().transpose(Predef$.MODULE$.$conforms())).zip(table.names())).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Seq column = (Seq)tuple2._1();
                String name = (String)tuple2._2();
                Seq inputTypes = (Seq)column.map((Function1 & Serializable)x$2 -> x$2.dataType());
                DataType tpe = (DataType)TypeCoercion$.MODULE$.findWiderTypeWithoutStringPromotion((Seq<DataType>)inputTypes).getOrElse((Function0 & Serializable)() -> package$.MODULE$.AnalysisErrorAt(table).failAnalysis("INVALID_INLINE_TABLE.INCOMPATIBLE_TYPES_IN_INLINE_TABLE", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"colName"), (Object)TypeUtils$.MODULE$.toSQLId(name))})))));
                Seq newColumn = (Seq)column.map((Function1 & Serializable)x0$2 -> {
                    Expression expression = x0$2;
                    if (DataTypeUtils$.MODULE$.sameType(expression.dataType(), tpe)) {
                        return expression;
                    }
                    return MODULE$.cast(expression, tpe);
                });
                return new Tuple2((Object)new StructField(name, tpe, column.exists((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.nullable())), StructField$.MODULE$.apply$default$4()), (Object)newColumn);
            }
            throw new MatchError((Object)tuple2);
        })).unzip(Predef$.MODULE$.$conforms());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Seq fields = (Seq)tuple2._1();
        Seq columns = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)fields, (Object)columns);
        Seq fields2 = (Seq)tuple22._1();
        Seq columns2 = (Seq)tuple22._2();
        Predef$.MODULE$.assert(fields2.size() == table.names().size());
        Seq<AttributeReference> attributes = DataTypeUtils$.MODULE$.toAttributes(StructType$.MODULE$.apply(fields2));
        Seq castedRows = (Seq)columns2.transpose(Predef$.MODULE$.$conforms());
        return new ResolvedInlineTable((Seq<Seq<Expression>>)castedRows, attributes);
    }

    public static final /* synthetic */ boolean $anonfun$earlyEvalIfPossible$1(Expression x$1) {
        return !x$1.containsPattern(TreePattern$.MODULE$.CURRENT_LIKE());
    }

    public static final /* synthetic */ void $anonfun$validateInputDimension$1(int numCols$1, UnresolvedInlineTable table$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            Seq row = (Seq)tuple2._1();
            int rowIndex = tuple2._2$mcI$sp();
            if (row.size() != numCols$1) {
                throw package$.MODULE$.AnalysisErrorAt(table$1).failAnalysis("INVALID_INLINE_TABLE.NUM_COLUMNS_MISMATCH", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"expectedNumCols"), (Object)Integer.toString(numCols$1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"actualNumCols"), (Object)Integer.toString(row.size())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"rowIndex"), (Object)Integer.toString(rowIndex))}))));
            }
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$validateInputEvaluable$2(Expression e) {
        if (e.containsPattern(TreePattern$.MODULE$.CURRENT_LIKE())) {
            return;
        }
        if (!e.resolved() || !MODULE$.trimAliases(MODULE$.prepareForEval(e)).foldable()) {
            throw package$.MODULE$.AnalysisErrorAt(e).failAnalysis("INVALID_INLINE_TABLE.CANNOT_EVALUATE_EXPRESSION_IN_INLINE_TABLE", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"expr"), (Object)TypeUtils$.MODULE$.toSQLExpr(e))}))));
        }
    }

    private EvaluateUnresolvedInlineTable$() {
    }
}

