/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.util;

import java.io.Serializable;
import org.apache.hadoop.HadoopIllegalArgumentException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.ApplicationConstants;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.spark.deploy.yarn.YarnSparkHadoopUtil$;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;

public final class YarnContainerInfoHelper$
implements Logging {
    public static final YarnContainerInfoHelper$ MODULE$ = new YarnContainerInfoHelper$();
    private static final Seq<String> DRIVER_LOG_FILE_NAMES;
    private static final int DRIVER_LOG_START_OFFSET;
    private static transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        Logging.$init$((Logging)MODULE$);
        DRIVER_LOG_FILE_NAMES = new .colon.colon((Object)"stdout", (List)new .colon.colon((Object)"stderr", (List)Nil$.MODULE$));
        DRIVER_LOG_START_OFFSET = -4096;
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(java.util.Map<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public MDC MDC(LogKey key, Object value) {
        return Logging.MDC$((Logging)this, (LogKey)key, (Object)value);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void logBasedOnLevel(Level level, Function0<MessageWithContext> f) {
        Logging.logBasedOnLevel$((Logging)this, (Level)level, f);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public Map<String, String> getLogUrlsFromBaseUrl(String baseUrl) {
        return ((IterableOnceOps)DRIVER_LOG_FILE_NAMES.map((Function1 & Serializable)fname -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(fname), (Object)(baseUrl + "/" + fname + "?start=" + DRIVER_LOG_START_OFFSET)))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public Option<Map<String, String>> getLogUrls(Configuration conf, Option<Container> container) {
        None$ none$;
        try {
            YarnConfiguration yarnConf = new YarnConfiguration(conf);
            ContainerId containerId = this.getContainerId(container);
            String user = Utils$.MODULE$.getCurrentUserName();
            String httpScheme = this.getYarnHttpScheme(yarnConf);
            String httpAddress = this.getNodeManagerHttpAddress(container);
            String baseUrl = httpScheme + httpAddress + "/node/containerlogs/" + containerId + "/" + user;
            this.logDebug((Function0<String>)(Function0 & Serializable)() -> "Base URL for logs: " + baseUrl);
            none$ = new Some(this.getLogUrlsFromBaseUrl(baseUrl));
        }
        catch (Exception e) {
            this.logInfo((Function0<String>)(Function0 & Serializable)() -> "Error while building executor logs - executor logs will not be available", (Throwable)e);
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public Option<Map<String, String>> getAttributes(Configuration conf, Option<Container> container) {
        Some some;
        try {
            YarnConfiguration yarnConf = new YarnConfiguration(conf);
            some = new Some(Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"HTTP_SCHEME"), (Object)this.getYarnHttpScheme(yarnConf)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"NM_HOST"), (Object)this.getNodeManagerHost(container)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"NM_PORT"), (Object)this.getNodeManagerPort(container)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"NM_HTTP_PORT"), (Object)this.getNodeManagerHttpPort(container)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"NM_HTTP_ADDRESS"), (Object)this.getNodeManagerHttpAddress(container)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"CLUSTER_ID"), this.getClusterId(yarnConf).getOrElse((Function0 & Serializable)() -> "")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"CONTAINER_ID"), (Object)this.convertToString(this.getContainerId(container))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"USER"), (Object)Utils$.MODULE$.getCurrentUserName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"LOG_FILES"), (Object)"stderr,stdout")})));
        }
        catch (Exception e) {
            this.logInfo((Function0<String>)(Function0 & Serializable)() -> "Error while retrieving executor attributes - executor logs will not be replaced with custom log pattern", (Throwable)e);
            some = None$.MODULE$;
        }
        return some;
    }

    public String convertToString(ContainerId containerId) {
        if (containerId != null) {
            return containerId.toString();
        }
        return null;
    }

    public ContainerId getContainerId(Option<Container> container) {
        Option<Container> option = container;
        if (option instanceof Some) {
            Some some = (Some)option;
            Container c = (Container)some.value();
            return c.getId();
        }
        if (None$.MODULE$.equals(option)) {
            return YarnSparkHadoopUtil$.MODULE$.getContainerId();
        }
        throw new MatchError(option);
    }

    public Option<String> getClusterId(YarnConfiguration yarnConf) {
        Some some;
        try {
            some = new Some((Object)YarnConfiguration.getClusterId((Configuration)yarnConf));
        }
        catch (HadoopIllegalArgumentException hadoopIllegalArgumentException) {
            some = None$.MODULE$;
        }
        return some;
    }

    public String getYarnHttpScheme(YarnConfiguration yarnConf) {
        String yarnHttpPolicy;
        String string = yarnHttpPolicy = yarnConf.get("yarn.http.policy", YarnConfiguration.YARN_HTTP_POLICY_DEFAULT);
        String string2 = "HTTPS_ONLY";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            return "https://";
        }
        return "http://";
    }

    public String getNodeManagerHttpAddress(Option<Container> container) {
        Option<Container> option = container;
        if (option instanceof Some) {
            Some some = (Some)option;
            Container c = (Container)some.value();
            return c.getNodeHttpAddress();
        }
        if (None$.MODULE$.equals(option)) {
            return this.getNodeManagerHost((Option<Container>)None$.MODULE$) + ":" + this.getNodeManagerHttpPort((Option<Container>)None$.MODULE$);
        }
        throw new MatchError(option);
    }

    public String getNodeManagerHost(Option<Container> container) {
        Option<Container> option = container;
        if (option instanceof Some) {
            Some some = (Some)option;
            Container c = (Container)some.value();
            return c.getNodeHttpAddress().split(":")[0];
        }
        if (None$.MODULE$.equals(option)) {
            return System.getenv(ApplicationConstants.Environment.NM_HOST.name());
        }
        throw new MatchError(option);
    }

    public String getNodeManagerHttpPort(Option<Container> container) {
        Option<Container> option = container;
        if (option instanceof Some) {
            Some some = (Some)option;
            Container c = (Container)some.value();
            return c.getNodeHttpAddress().split(":")[1];
        }
        if (None$.MODULE$.equals(option)) {
            return System.getenv(ApplicationConstants.Environment.NM_HTTP_PORT.name());
        }
        throw new MatchError(option);
    }

    public String getNodeManagerPort(Option<Container> container) {
        Option<Container> option = container;
        if (option instanceof Some) {
            return "-1";
        }
        if (None$.MODULE$.equals(option)) {
            return System.getenv(ApplicationConstants.Environment.NM_PORT.name());
        }
        throw new MatchError(option);
    }

    private YarnContainerInfoHelper$() {
    }
}

