/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.client.impl;

import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.json.JsonArray;
import io.vertx.ext.web.client.HttpResponse;
import io.vertx.ext.web.codec.impl.BodyCodecImpl;
import java.util.List;

public class HttpResponseImpl<T>
implements HttpResponse<T> {
    private final HttpVersion version;
    private final int statusCode;
    private final String statusMessage;
    private final MultiMap headers;
    private final MultiMap trailers;
    private final List<String> cookies;
    private final T body;
    private final List<String> redirects;

    public HttpResponseImpl(HttpVersion version, int statusCode, String statusMessage, MultiMap headers, MultiMap trailers, List<String> cookies, T body, List<String> redirects) {
        this.version = version;
        this.statusCode = statusCode;
        this.statusMessage = statusMessage;
        this.headers = headers;
        this.trailers = trailers;
        this.cookies = cookies;
        this.body = body;
        this.redirects = redirects;
    }

    public HttpVersion version() {
        return this.version;
    }

    public int statusCode() {
        return this.statusCode;
    }

    public String statusMessage() {
        return this.statusMessage;
    }

    public String getHeader(String headerName) {
        return this.headers.get(headerName);
    }

    public String getHeader(CharSequence headerName) {
        return this.headers.get(headerName);
    }

    @Override
    public MultiMap trailers() {
        return this.trailers;
    }

    @Override
    public String getTrailer(String trailerName) {
        return this.trailers.get(trailerName);
    }

    public List<String> cookies() {
        return this.cookies;
    }

    public MultiMap headers() {
        return this.headers;
    }

    @Override
    public T body() {
        return this.body;
    }

    @Override
    public Buffer bodyAsBuffer() {
        return this.body instanceof Buffer ? (Buffer)this.body : null;
    }

    @Override
    public List<String> followedRedirects() {
        return this.redirects;
    }

    @Override
    public JsonArray bodyAsJsonArray() {
        Buffer b = this.bodyAsBuffer();
        return b != null ? (JsonArray)BodyCodecImpl.JSON_ARRAY_DECODER.apply(b) : null;
    }
}

