/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.zookeeper;

import java.io.IOException;
import org.apache.flink.runtime.zookeeper.ZooKeeperVersionedValue;
import org.apache.flink.shaded.curator4.org.apache.curator.framework.recipes.shared.SharedCount;
import org.apache.flink.util.Preconditions;

public class ZooKeeperSharedCount {
    private final SharedCount sharedCount;

    public ZooKeeperSharedCount(SharedCount sharedCount) {
        this.sharedCount = (SharedCount)Preconditions.checkNotNull((Object)sharedCount);
    }

    public void start() throws Exception {
        this.sharedCount.start();
    }

    public void close() throws IOException {
        this.sharedCount.close();
    }

    public ZooKeeperVersionedValue<Integer> getVersionedValue() {
        return new ZooKeeperVersionedValue<Integer>(this.sharedCount.getVersionedValue());
    }

    public boolean trySetCount(ZooKeeperVersionedValue<Integer> previous, int newCount) throws Exception {
        return this.sharedCount.trySetCount(previous.getVersionedValue(), newCount);
    }
}

