/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.console.core.controller;

import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.apache.streampark.console.core.service.ProxyService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Validated
@RestController
@RequestMapping(value={"proxy"})
public class ProxyController {
    private static final Logger log = LoggerFactory.getLogger(ProxyController.class);
    @Autowired
    private ProxyService proxyService;

    @GetMapping(value={"{type}/{id}/assets/**"})
    public ResponseEntity<?> proxyFlinkAssets(HttpServletRequest request, @PathVariable(value="type") String type, @PathVariable(value="id") Long id) throws Exception {
        return this.proxy(type, request, id);
    }

    @GetMapping(value={"{type}/{id}/**"})
    @RequiresPermissions(value={"app:view"})
    public ResponseEntity<?> proxyFlink(HttpServletRequest request, @PathVariable(value="type") String type, @PathVariable(value="id") Long id) throws Exception {
        return this.proxy(type, request, id);
    }

    private ResponseEntity<?> proxy(String type, HttpServletRequest request, Long id) throws Exception {
        switch (type) {
            case "flink": {
                return this.proxyService.proxyFlink(request, id);
            }
            case "cluster": {
                return this.proxyService.proxyCluster(request, id);
            }
            case "history": {
                return this.proxyService.proxyHistory(request, id);
            }
            case "yarn": {
                return this.proxyService.proxyYarn(request, id);
            }
        }
        return ResponseEntity.notFound().build();
    }
}

