/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.console.system.authentication;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermissions;
import java.security.SecureRandom;
import java.util.Base64;
import org.apache.streampark.common.util.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JWTSecret {
    private static final Logger log = LoggerFactory.getLogger(JWTSecret.class);
    private static final int KEY_LENGTH = 32;

    public static byte[] getJWTSecret() {
        Path keyPath = Paths.get(System.getProperty("user.home"), "streampark.jwt.key");
        File keyFile = keyPath.toFile();
        byte[] keyBytes = JWTSecret.loadExistingKey(keyFile);
        if (keyBytes != null) {
            return keyBytes;
        }
        keyBytes = JWTSecret.generateNewKey();
        JWTSecret.saveNewKey(keyBytes, keyPath);
        return keyBytes;
    }

    private static byte[] loadExistingKey(File keyFile) {
        if (!keyFile.exists()) {
            return null;
        }
        try {
            String secret = FileUtils.readFile((File)keyFile).trim();
            byte[] keyBytes = Base64.getDecoder().decode(secret);
            if (keyBytes.length != 32) {
                log.error("Invalid HMAC key length: {} bytes (expected {} bytes)", (Object)keyBytes.length, (Object)32);
                return null;
            }
            return keyBytes;
        }
        catch (Exception e) {
            log.error("Failed to read JWT key file", (Throwable)e);
            JWTSecret.safelyDeleteFile(keyFile);
            return null;
        }
    }

    private static byte[] generateNewKey() {
        byte[] key = new byte[32];
        new SecureRandom().nextBytes(key);
        return key;
    }

    private static void saveNewKey(byte[] keyBytes, Path keyPath) {
        String encodedKey = Base64.getEncoder().encodeToString(keyBytes);
        try {
            Files.createDirectories(keyPath.getParent(), new FileAttribute[0]);
            Path tempFile = Files.createTempFile(keyPath.getParent(), "streampark", ".tmp", new FileAttribute[0]);
            Files.write(tempFile, encodedKey.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            JWTSecret.setStrictPermissions(tempFile);
            Files.move(tempFile, keyPath, StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (Exception e) {
            throw new SecurityException("Failed to generate JWT key", e);
        }
    }

    private static void setStrictPermissions(Path path) {
        try {
            Files.setPosixFilePermissions(path, PosixFilePermissions.fromString("rw-------"));
        }
        catch (UnsupportedOperationException e) {
            log.warn("POSIX permissions not supported for {}", (Object)path);
        }
        catch (IOException e) {
            log.error("Failed to set permissions for {}", (Object)path, (Object)e);
        }
    }

    private static void safelyDeleteFile(File keyFile) {
        try {
            if (keyFile.exists() && !keyFile.delete()) {
                log.warn("Failed to delete invalid key file: {}", (Object)keyFile.getAbsolutePath());
            }
        }
        catch (SecurityException e) {
            log.error("Security exception when deleting key file", (Throwable)e);
        }
    }
}

