/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.console.system.authentication;

import java.util.Set;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.authz.SimpleAuthorizationInfo;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.streampark.common.util.SystemPropertyUtils;
import org.apache.streampark.console.core.enums.AuthenticationType;
import org.apache.streampark.console.system.authentication.JWTToken;
import org.apache.streampark.console.system.authentication.JWTUtil;
import org.apache.streampark.console.system.entity.AccessToken;
import org.apache.streampark.console.system.entity.User;
import org.apache.streampark.console.system.service.AccessTokenService;
import org.apache.streampark.console.system.service.UserService;
import org.springframework.beans.factory.annotation.Autowired;

public class ShiroRealm
extends AuthorizingRealm {
    @Autowired
    private UserService userService;
    @Autowired
    private AccessTokenService accessTokenService;

    public boolean supports(AuthenticationToken token) {
        return token instanceof JWTToken;
    }

    protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection token) {
        Long userId = JWTUtil.getUserId(token.toString());
        SimpleAuthorizationInfo simpleAuthorizationInfo = new SimpleAuthorizationInfo();
        Set<String> permissionSet = this.userService.getPermissions(userId, null);
        simpleAuthorizationInfo.setStringPermissions(permissionSet);
        return simpleAuthorizationInfo;
    }

    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken authenticationToken) throws AuthenticationException {
        String credential = (String)authenticationToken.getCredentials();
        String username = JWTUtil.getUserName(credential);
        Long userId = JWTUtil.getUserId(credential);
        AuthenticationType authType = JWTUtil.getAuthType(credential);
        if (username == null || userId == null || authType == null) {
            throw new AuthenticationException("the authorization token is invalid");
        }
        User user = this.userService.findByName(username);
        if (user == null || !user.getUserId().equals(userId)) {
            throw new AuthenticationException("the authorization token verification failed.");
        }
        switch (authType) {
            case SIGN: {
                Long timestamp = JWTUtil.getTimestamp(credential);
                Long startTime = SystemPropertyUtils.getLong((String)"streampark.start.timestamp", (long)0L);
                if (timestamp >= startTime) break;
                throw new AuthenticationException("the authorization token is expired");
            }
            case OPENAPI: {
                AccessToken accessToken = this.accessTokenService.getByUserId(userId);
                try {
                    String encryptToken = JWTUtil.encrypt(credential);
                    if (accessToken == null || !accessToken.getToken().equals(encryptToken)) {
                        throw new AuthenticationException("the openapi authorization token is invalid");
                    }
                }
                catch (Exception e) {
                    throw new AuthenticationException((Throwable)e);
                }
                if (AccessToken.STATUS_DISABLE.equals(accessToken.getStatus())) {
                    throw new AuthenticationException("The OpenAPI authorization token is disabled. Please contact the administrator.");
                }
                if ("0".equals(accessToken.getUserStatus())) {
                    throw new AuthenticationException("the user [" + username + "] has been locked, please contact the administrator");
                }
                SecurityUtils.getSubject().getSession().setAttribute((Object)"is_api_token", (Object)true);
                break;
            }
        }
        return new SimpleAuthenticationInfo((Object)credential, (Object)credential, "streampark_shiro_realm");
    }
}

