/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.disk.iomanager;

import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.flink.runtime.io.disk.iomanager.AsynchronousFileIOChannel;
import org.apache.flink.runtime.io.disk.iomanager.BufferFileChannelReader;
import org.apache.flink.runtime.io.disk.iomanager.ReadRequest;
import org.apache.flink.runtime.io.network.buffer.Buffer;

final class BufferReadRequest
implements ReadRequest {
    private final AsynchronousFileIOChannel<Buffer, ReadRequest> channel;
    private final Buffer buffer;
    private final AtomicBoolean hasReachedEndOfFile;

    protected BufferReadRequest(AsynchronousFileIOChannel<Buffer, ReadRequest> targetChannel, Buffer buffer, AtomicBoolean hasReachedEndOfFile) {
        this.channel = targetChannel;
        this.buffer = buffer;
        this.hasReachedEndOfFile = hasReachedEndOfFile;
    }

    @Override
    public void read() throws IOException {
        FileChannel fileChannel = this.channel.fileChannel;
        if (fileChannel.size() - fileChannel.position() > 0L) {
            BufferFileChannelReader reader = new BufferFileChannelReader(fileChannel);
            this.hasReachedEndOfFile.set(reader.readBufferFromFileChannel(this.buffer));
        } else {
            this.hasReachedEndOfFile.set(true);
        }
    }

    @Override
    public void requestDone(IOException error) {
        this.channel.handleProcessedBuffer(this.buffer, error);
    }
}

