/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.flink.kubernetes;

import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.api.model.apps.DeploymentList;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.Filterable;
import io.fabric8.kubernetes.client.dsl.Listable;
import java.io.Serializable;
import javax.annotation.Nullable;
import org.apache.flink.client.cli.ClientOptions;
import org.apache.flink.client.deployment.ClusterClientFactory;
import org.apache.flink.client.deployment.DefaultClusterClientServiceLoader;
import org.apache.flink.client.program.ClusterClient;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.DeploymentOptions;
import org.apache.flink.configuration.RestOptions;
import org.apache.flink.kubernetes.KubernetesClusterDescriptor;
import org.apache.flink.kubernetes.configuration.KubernetesConfigOptions;
import org.apache.streampark.common.util.Logger;
import org.apache.streampark.common.util.Utils$;
import org.apache.streampark.flink.kubernetes.enums.FlinkK8sExecuteMode$;
import org.apache.streampark.flink.kubernetes.ingress.IngressController$;
import org.apache.streampark.flink.kubernetes.model.ClusterKey;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.Null$;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class KubernetesRetriever$
implements Logger {
    public static KubernetesRetriever$ MODULE$;
    private final Map<String, Object> DEPLOYMENT_LOST_TIME;
    private final DefaultClusterClientServiceLoader clusterClientServiceLoader;
    private transient org.apache.streampark.shaded.org.slf4j.Logger org$apache$streampark$common$util$Logger$$_logger;
    private final String org$apache$streampark$common$util$Logger$$prefix;

    static {
        new KubernetesRetriever$();
    }

    public String logName() {
        return Logger.logName$((Logger)this);
    }

    public org.apache.streampark.shaded.org.slf4j.Logger logger() {
        return Logger.logger$((Logger)this);
    }

    public void logInfo(Function0<String> msg) {
        Logger.logInfo$((Logger)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logger.logInfo$((Logger)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logger.logDebug$((Logger)this, msg);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logger.logDebug$((Logger)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logger.logTrace$((Logger)this, msg);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logger.logTrace$((Logger)this, msg, (Throwable)throwable);
    }

    public void logWarn(Function0<String> msg) {
        Logger.logWarn$((Logger)this, msg);
    }

    public void logWarn(Function0<String> msg, Throwable throwable) {
        Logger.logWarn$((Logger)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logger.logError$((Logger)this, msg);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logger.logError$((Logger)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logger.isTraceEnabled$((Logger)this);
    }

    public org.apache.streampark.shaded.org.slf4j.Logger org$apache$streampark$common$util$Logger$$_logger() {
        return this.org$apache$streampark$common$util$Logger$$_logger;
    }

    public void org$apache$streampark$common$util$Logger$$_logger_$eq(org.apache.streampark.shaded.org.slf4j.Logger x$1) {
        this.org$apache$streampark$common$util$Logger$$_logger = x$1;
    }

    public String org$apache$streampark$common$util$Logger$$prefix() {
        return this.org$apache$streampark$common$util$Logger$$prefix;
    }

    public final void org$apache$streampark$common$util$Logger$_setter_$org$apache$streampark$common$util$Logger$$prefix_$eq(String x$1) {
        this.org$apache$streampark$common$util$Logger$$prefix = x$1;
    }

    private Map<String, Object> DEPLOYMENT_LOST_TIME() {
        return this.DEPLOYMENT_LOST_TIME;
    }

    public KubernetesClient newK8sClient() throws KubernetesClientException {
        return new DefaultKubernetesClient();
    }

    public boolean checkK8sConnection() {
        return BoxesRunTime.unboxToBoolean((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> MODULE$.newK8sClient().getVersion() != null).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false));
    }

    private DefaultClusterClientServiceLoader clusterClientServiceLoader() {
        return this.clusterClientServiceLoader;
    }

    private Option<ClusterClient<String>> newFinkClusterClient(String clusterId, @Nullable String namespace, Enumeration.Value executeMode) {
        Configuration flinkConfig = new Configuration();
        flinkConfig.setString(DeploymentOptions.TARGET, executeMode.toString());
        flinkConfig.setString(KubernetesConfigOptions.CLUSTER_ID, clusterId);
        flinkConfig.set(ClientOptions.CLIENT_TIMEOUT, ClientOptions.CLIENT_TIMEOUT.defaultValue());
        flinkConfig.set(RestOptions.AWAIT_LEADER_TIMEOUT, RestOptions.AWAIT_LEADER_TIMEOUT.defaultValue());
        flinkConfig.set(RestOptions.RETRY_MAX_ATTEMPTS, RestOptions.RETRY_MAX_ATTEMPTS.defaultValue());
        if (BoxesRunTime.unboxToBoolean((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> namespace.isEmpty()).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> true))) {
            flinkConfig.setString(KubernetesConfigOptions.NAMESPACE, (String)KubernetesConfigOptions.NAMESPACE.defaultValue());
        } else {
            flinkConfig.setString(KubernetesConfigOptions.NAMESPACE, namespace);
        }
        ClusterClientFactory clientFactory = this.clusterClientServiceLoader().getClusterClientFactory(flinkConfig);
        KubernetesClusterDescriptor x$1 = (KubernetesClusterDescriptor)clientFactory.createClusterDescriptor(flinkConfig);
        Function1 & Serializable & scala.Serializable x$2 = (Function1 & Serializable & scala.Serializable)clusterProvider -> {
            Some some;
            Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> clusterProvider.retrieve(flinkConfig.getString(KubernetesConfigOptions.CLUSTER_ID)).getClusterClient());
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                ClusterClient v = (ClusterClient)success.value();
                some = new Some((Object)v);
            } else if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable e = failure.exception();
                MODULE$.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(37).append("Get flinkClient error, the error is: ").append(e).toString());
                some = None$.MODULE$;
            } else {
                throw new MatchError((Object)try_);
            }
            return some;
        };
        Null$ x$3 = Utils$.MODULE$.using$default$3((AutoCloseable)x$1, (Function1)x$2);
        return (Option)Utils$.MODULE$.using((AutoCloseable)x$1, (Function1)x$2, null);
    }

    public boolean isDeploymentExists(String namespace, String deploymentName) {
        boolean bl;
        Object object = new Object();
        try {
            bl = BoxesRunTime.unboxToBoolean((Object)Utils$.MODULE$.using((AutoCloseable)this.newK8sClient(), (Function1 & Serializable & scala.Serializable)client -> BoxesRunTime.boxToBoolean((boolean)KubernetesRetriever$.$anonfun$isDeploymentExists$1(namespace, deploymentName, client)), (Function1 & Serializable & scala.Serializable)e -> BoxesRunTime.boxToBoolean((boolean)KubernetesRetriever$.$anonfun$isDeploymentExists$3(namespace, deploymentName, object, e))));
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                bl = ex.value$mcZ$sp();
            }
            throw ex;
        }
        return bl;
    }

    public Option<String> retrieveFlinkRestUrl(ClusterKey clusterKey) {
        Option option;
        Object object = new Object();
        try {
            String url = IngressController$.MODULE$.getIngressUrl(clusterKey.namespace(), clusterKey.clusterId(), (Function0 & Serializable & scala.Serializable)() -> (ClusterClient)MODULE$.newFinkClusterClient(clusterKey.clusterId(), clusterKey.namespace(), clusterKey.executeMode()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                throw new NonLocalReturnControl(object, (Object)None$.MODULE$);
            }));
            this.logger().info(new StringBuilder(36).append("retrieve flink jobManager rest url: ").append(url).toString());
            option = new Some((Object)url);
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                option = (Option)ex.value();
            }
            throw ex;
        }
        return option;
    }

    public String getSessionClusterIngressURL(String namespace, String clusterId) {
        return (String)this.retrieveFlinkRestUrl(new ClusterKey(FlinkK8sExecuteMode$.MODULE$.SESSION(), namespace, clusterId)).orNull(Predef$.MODULE$.$conforms());
    }

    public static final /* synthetic */ boolean $anonfun$isDeploymentExists$2(String deploymentName$1, Deployment x$1) {
        String string = x$1.getMetadata().getName();
        String string2 = deploymentName$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$isDeploymentExists$1(String namespace$2, String deploymentName$1, KubernetesClient client) {
        return ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(((DeploymentList)((Listable)((Filterable)client.apps().deployments().inNamespace(namespace$2)).withLabel("type", "flink-native-kubernetes")).list()).getItems()).asScala()).exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)KubernetesRetriever$.$anonfun$isDeploymentExists$2(deploymentName$1, x$1)));
    }

    public static final /* synthetic */ boolean $anonfun$isDeploymentExists$3(String namespace$2, String deploymentName$1, Object nonLocalReturnKey1$1, Throwable e) {
        MODULE$.logWarn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(152).append("\n             |[StreamPark] check deploymentExists WARN,\n             |namespace: ").append(namespace$2).append(",\n             |deploymentName: ").append(deploymentName$1).append(",\n             |error: ").append(e).append("\n             |").toString())).stripMargin());
        String key = new StringBuilder(1).append(namespace$2).append("_").append(deploymentName$1).toString();
        Option option = MODULE$.DEPLOYMENT_LOST_TIME().get((Object)key);
        if (option instanceof Some) {
            Some some = (Some)option;
            long time = BoxesRunTime.unboxToLong((Object)some.value());
            long timeOut = 180000L;
            if (System.currentTimeMillis() - time >= timeOut) {
                MODULE$.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(229).append("\n                   |[StreamPark] check deploymentExists Failed,\n                   |namespace: ").append(namespace$2).append(",\n                   |deploymentName: ").append(deploymentName$1).append(",\n                   |detail: deployment: ").append(deploymentName$1).append(" Not Found more than 3 minutes, ").append(e).append("\n                   |").toString())).stripMargin());
                MODULE$.DEPLOYMENT_LOST_TIME().$minus$eq((Object)key);
                throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, false);
            }
            throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, true);
        }
        MODULE$.DEPLOYMENT_LOST_TIME().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)BoxesRunTime.boxToLong((long)System.currentTimeMillis())));
        boolean bl = true;
        return bl;
    }

    private KubernetesRetriever$() {
        MODULE$ = this;
        Logger.$init$((Logger)this);
        this.DEPLOYMENT_LOST_TIME = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.clusterClientServiceLoader = new DefaultClusterClientServiceLoader();
    }
}

