/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.console.base.util;

import freemarker.cache.StringTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.core.TemplateClassResolver;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.ResourceLoader;
import org.springframework.ui.freemarker.SpringTemplateLoader;

public class FreemarkerUtils {
    private static final Logger log = LoggerFactory.getLogger(FreemarkerUtils.class);
    private static final Configuration CONFIGURATION;

    public static Template loadTemplateFile(String fileName) throws ExceptionInInitializerError {
        try {
            return CONFIGURATION.getTemplate(fileName);
        }
        catch (IOException e) {
            log.error("{} not found!", (Object)fileName);
            throw new ExceptionInInitializerError(fileName + " not found!");
        }
    }

    public static Template loadTemplateString(String template) throws Exception {
        Configuration configuration = new Configuration(Configuration.VERSION_2_3_28);
        configuration.setNewBuiltinClassResolver(TemplateClassResolver.SAFER_RESOLVER);
        StringTemplateLoader stringTemplateLoader = new StringTemplateLoader();
        stringTemplateLoader.putTemplate("template", template);
        configuration.setTemplateLoader((TemplateLoader)stringTemplateLoader);
        return configuration.getTemplate("template");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String format(Template template, Object dataModel) throws TemplateException {
        try (StringWriter writer = new StringWriter();){
            template.process(dataModel, (Writer)writer);
            String string = writer.toString();
            return string;
        }
        catch (IOException e) {
            log.error(e.getMessage());
            return null;
        }
    }

    static {
        SpringTemplateLoader templateLoader = new SpringTemplateLoader((ResourceLoader)new DefaultResourceLoader(), "classpath:alert-template");
        CONFIGURATION = new Configuration(Configuration.VERSION_2_3_28);
        CONFIGURATION.setNewBuiltinClassResolver(TemplateClassResolver.SAFER_RESOLVER);
        CONFIGURATION.setTemplateLoader((TemplateLoader)templateLoader);
        CONFIGURATION.setDefaultEncoding("UTF-8");
    }
}

