/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse;

import java.io.File;
import javax.servlet.ServletConfig;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.ServerConfigurationInformation;
import org.apache.synapse.SynapseException;

public class ServerConfigurationInformationFactory {
    private static final Log log = LogFactory.getLog(ServerConfigurationInformationFactory.class);

    public static ServerConfigurationInformation createServerConfigurationInformation(AxisConfiguration axisConfiguration) {
        ServerConfigurationInformation information = new ServerConfigurationInformation();
        information.setSynapseHome(ServerConfigurationInformationFactory.getAxis2ParameterValue(axisConfiguration, "SynapseConfig.HomeDirectory"));
        information.setSynapseXMLLocation(ServerConfigurationInformationFactory.getAxis2ParameterValue(axisConfiguration, "SynapseConfig.ConfigurationFile"));
        information.setServerName(ServerConfigurationInformationFactory.getAxis2ParameterValue(axisConfiguration, "SynapseConfig.ServerName"));
        information.setResolveRoot(ServerConfigurationInformationFactory.getAxis2ParameterValue(axisConfiguration, "SynapseConfig.ResolveRoot"));
        return information;
    }

    public static ServerConfigurationInformation createServerConfigurationInformation(CommandLine cmd) {
        ServerConfigurationInformation information = new ServerConfigurationInformation();
        information.setAxis2RepoLocation(ServerConfigurationInformationFactory.getArgument(cmd, "axis2.xml"));
        information.setAxis2Xml(ServerConfigurationInformationFactory.getArgument(cmd, "synapse.xml"));
        information.setSynapseHome(ServerConfigurationInformationFactory.getArgument(cmd, "synapse.home"));
        information.setSynapseXMLLocation(ServerConfigurationInformationFactory.getArgument(cmd, "synapse.xml"));
        information.setResolveRoot(ServerConfigurationInformationFactory.getArgument(cmd, "resolve.root"));
        information.setDeploymentMode(ServerConfigurationInformationFactory.getArgument(cmd, "deployment.mode"));
        information.setServerName(ServerConfigurationInformationFactory.getArgument(cmd, "serverName"));
        return information;
    }

    public static ServerConfigurationInformation createServerConfigurationInformation(String[] args) {
        ServerConfigurationInformation information = new ServerConfigurationInformation();
        information.setAxis2RepoLocation(args[0]);
        if (args.length == 1) {
            log.warn((Object)"Configuring server manager using deprecated system properties; please update your configuration");
            information.setAxis2Xml(System.getProperty("axis2.xml"));
            information.setSynapseHome(System.getProperty("synapse.home"));
            information.setSynapseXMLLocation(System.getProperty("synapse.xml"));
            information.setResolveRoot(System.getProperty("resolve.root"));
            information.setServerName(System.getProperty("serverName"));
            information.setDeploymentMode(System.getProperty("deployment.mode"));
        } else if (args.length == 4) {
            information.setAxis2Xml(args[1]);
            information.setSynapseHome(args[2]);
            information.setSynapseXMLLocation(args[3]);
            information.setResolveRoot(args[2] + File.separator + "repository");
        } else if (args.length == 5) {
            information.setAxis2Xml(args[1]);
            information.setSynapseHome(args[2]);
            information.setSynapseXMLLocation(args[3]);
            information.setResolveRoot(args[4]);
        } else if (args.length == 6) {
            information.setAxis2Xml(args[1]);
            information.setSynapseHome(args[2]);
            information.setSynapseXMLLocation(args[3]);
            information.setResolveRoot(args[4]);
            if (args[5].equalsIgnoreCase("synapseDebug")) {
                information.setSynapseDebug(true);
            } else {
                information.setDeploymentMode(args[5]);
            }
        } else if (args.length == 7) {
            information.setAxis2Xml(args[1]);
            information.setSynapseHome(args[2]);
            information.setSynapseXMLLocation(args[3]);
            information.setResolveRoot(args[4]);
            information.setDeploymentMode(args[5]);
            information.setServerName(args[6]);
        }
        return information;
    }

    public static ServerConfigurationInformation createServerConfigurationInformation(ServletConfig servletConfig) {
        ServerConfigurationInformation information = new ServerConfigurationInformation();
        String synapseHome = ServerConfigurationInformationFactory.loadParameter(servletConfig, "synapse.home", false);
        if (synapseHome == null) {
            log.info((Object)"synapse.home not set; using web application root as default value");
            String webInfPath = servletConfig.getServletContext().getRealPath("WEB-INF");
            if (webInfPath == null || !webInfPath.endsWith("WEB-INF")) {
                ServerConfigurationInformationFactory.handleFatal("Unable to currentState web application root directory");
            } else {
                synapseHome = webInfPath.substring(0, webInfPath.length() - 7);
                log.info((Object)("Setting synapse.home to : " + synapseHome));
            }
        }
        information.setSynapseHome(synapseHome);
        information.setSynapseXMLLocation(ServerConfigurationInformationFactory.loadParameter(servletConfig, "synapse.xml", true));
        information.setResolveRoot(ServerConfigurationInformationFactory.loadParameter(servletConfig, "resolve.root", false));
        information.setAxis2RepoLocation(ServerConfigurationInformationFactory.loadParameter(servletConfig, "axis2.repo", true));
        information.setAxis2Xml(ServerConfigurationInformationFactory.loadParameter(servletConfig, "axis2.xml", true));
        information.setServerName(ServerConfigurationInformationFactory.loadParameter(servletConfig, "serverName", false));
        information.setDeploymentMode(ServerConfigurationInformationFactory.loadParameter(servletConfig, "deployment.mode", false));
        return information;
    }

    private static String getAxis2ParameterValue(AxisConfiguration axisConfiguration, String paramKey) {
        Parameter parameter = axisConfiguration.getParameter(paramKey);
        if (parameter == null) {
            return null;
        }
        Object value = parameter.getValue();
        if (value != null && value instanceof String) {
            return (String)parameter.getValue();
        }
        return null;
    }

    private static String getArgument(CommandLine cmd, String argName) {
        if (cmd == null) {
            ServerConfigurationInformationFactory.handleFatal("CommandLine is null");
        } else {
            if (argName == null || "".equals(argName)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Provided argument name is null. Returning null as value");
                }
                return null;
            }
            if (cmd.hasOption(argName)) {
                return cmd.getOptionValue(argName);
            }
        }
        return null;
    }

    private static String loadParameter(ServletConfig servletConfig, String name, boolean required) {
        if (System.getProperty(name) == null) {
            String value = servletConfig.getInitParameter(name);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Init parameter '" + name + "' : " + value));
            }
            if (value != null && value.trim().length() != 0 || !required) {
                return value;
            }
        } else {
            return System.getProperty(name);
        }
        ServerConfigurationInformationFactory.handleFatal("A valid system property or init parameter '" + name + "' is required");
        return null;
    }

    private static void handleFatal(String msg) {
        log.fatal((Object)msg);
        throw new SynapseException(msg);
    }
}

