/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.deployers;

import java.io.File;
import java.util.Properties;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.deployment.DeploymentException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.config.Entry;
import org.apache.synapse.config.xml.EntryFactory;
import org.apache.synapse.config.xml.EntrySerializer;
import org.apache.synapse.deployers.AbstractSynapseArtifactDeployer;

public class LocalEntryDeployer
extends AbstractSynapseArtifactDeployer {
    private static Log log = LogFactory.getLog(LocalEntryDeployer.class);

    @Override
    public String deploySynapseArtifact(OMElement artifactConfig, String fileName, Properties properties) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("LocalEntry Deployment from file : " + fileName + " : Started"));
        }
        try {
            Entry e = EntryFactory.createEntry(artifactConfig, properties);
            if (e != null) {
                e.setFileName(new File(fileName).getName());
                if (log.isDebugEnabled()) {
                    log.debug((Object)("LocalEntry with key '" + e.getKey() + "' has been built from the file " + fileName));
                }
                this.getSynapseConfiguration().addEntry(e.getKey(), e);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("LocalEntry Deployment from file : " + fileName + " : Completed"));
                }
                log.info((Object)("LocalEntry named '" + e.getKey() + "' has been deployed from file : " + fileName));
                return e.getKey();
            }
            this.handleSynapseArtifactDeploymentError("LocalEntry Deployment Failed. The artifact described in the file " + fileName + " is not a LocalEntry");
        }
        catch (Exception e) {
            this.handleSynapseArtifactDeploymentError("LocalEntry Deployment from the file : " + fileName + " : Failed.", e);
        }
        return null;
    }

    @Override
    public String updateSynapseArtifact(OMElement artifactConfig, String fileName, String existingArtifactName, Properties properties) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("LocalEntry update from file : " + fileName + " has started"));
        }
        try {
            Entry e = EntryFactory.createEntry(artifactConfig, properties);
            if (e == null) {
                this.handleSynapseArtifactDeploymentError("Local entry update failed. The artifact defined in the file: " + fileName + " is not a valid local entry.");
                return null;
            }
            e.setFileName(new File(fileName).getName());
            if (log.isDebugEnabled()) {
                log.debug((Object)("Local entry: " + e.getKey() + " has been built from the file: " + fileName));
            }
            if (existingArtifactName.equals(e.getKey())) {
                this.getSynapseConfiguration().updateEntry(existingArtifactName, e);
            } else {
                this.getSynapseConfiguration().addEntry(e.getKey(), e);
                this.getSynapseConfiguration().removeEntry(existingArtifactName);
                log.info((Object)("Local entry: " + existingArtifactName + " has been undeployed"));
            }
            log.info((Object)("Endpoint: " + e.getKey() + " has been updated from the file: " + fileName));
            return e.getKey();
        }
        catch (DeploymentException e) {
            this.handleSynapseArtifactDeploymentError("Error while updating the local entry from the file: " + fileName);
            return null;
        }
    }

    @Override
    public void undeploySynapseArtifact(String artifactName) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("LocalEntry Undeployment of the entry named : " + artifactName + " : Started"));
        }
        try {
            Entry e = this.getSynapseConfiguration().getDefinedEntries().get(artifactName);
            if (e != null && e.getType() != 3) {
                this.getSynapseConfiguration().removeEntry(artifactName);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("LocalEntry Undeployment of the entry named : " + artifactName + " : Completed"));
                }
                log.info((Object)("LocalEntry named '" + e.getKey() + "' has been undeployed"));
            } else if (log.isDebugEnabled()) {
                log.debug((Object)("Local entry " + artifactName + " has already been undeployed"));
            }
        }
        catch (Exception e) {
            this.handleSynapseArtifactDeploymentError("LocalEntry Undeployement of entry named : " + artifactName + " : Failed", e);
        }
    }

    @Override
    public void restoreSynapseArtifact(String artifactName) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("LocalEntry the Sequence with name : " + artifactName + " : Started"));
        }
        try {
            Entry e = this.getSynapseConfiguration().getDefinedEntries().get(artifactName);
            OMElement entryElem = EntrySerializer.serializeEntry(e, null);
            if (e.getFileName() != null) {
                String fileName = this.getServerConfigurationInformation().getSynapseXMLLocation() + File.separator + "local-entries" + File.separator + e.getFileName();
                this.writeToFile(entryElem, fileName);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Restoring the LocalEntry with name : " + artifactName + " : Completed"));
                }
                log.info((Object)("LocalEntry named '" + artifactName + "' has been restored"));
            } else {
                this.handleSynapseArtifactDeploymentError("Couldn't restore the LocalEntry named '" + artifactName + "', filename cannot be found");
            }
        }
        catch (Exception e) {
            this.handleSynapseArtifactDeploymentError("Restoring of the LocalEntry named '" + artifactName + "' has failed", e);
        }
    }
}

