/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.utils.sslcert.adaptor;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import javax.security.cert.X509Certificate;
import org.apache.synapse.transport.utils.sslcert.CertificateVerificationException;
import org.apache.synapse.transport.utils.sslcert.adaptor.ParentLastClassLoader;

public class SynapseAdaptorForOcspCrl {
    private static final ClassLoader loader = new ParentLastClassLoader(Thread.currentThread().getContextClassLoader());

    public void verifyRevocationStatus(X509Certificate[] peerCertificates, Integer cacheSize, Integer cacheDelay) throws CertificateVerificationException {
        if (peerCertificates == null || cacheSize == null || cacheDelay == null) {
            throw new IllegalArgumentException("Argument cannot be null");
        }
        try {
            Class<?> revocationManagerClass = loader.loadClass("org.apache.synapse.transport.utils.sslcert.RevocationVerificationManager");
            Method method = revocationManagerClass.getMethod("verifyRevocationStatus", peerCertificates.getClass());
            Constructor<?> constructor = revocationManagerClass.getConstructor(cacheSize.getClass(), cacheDelay.getClass());
            Object revocationManager = constructor.newInstance(cacheSize, cacheDelay);
            method.invoke(revocationManager, new Object[]{peerCertificates});
        }
        catch (Exception e) {
            throw new CertificateVerificationException("Failed to load BouncyCastle classes for certificate validation", e);
        }
    }
}

