/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.blob;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.axiom.blob.MemoryBlob;
import org.apache.axiom.blob.MemoryBlobChunk;
import org.apache.axiom.blob.MemoryBlobInputStream;
import org.apache.axiom.blob.MemoryBlobOutputStream;
import org.apache.axiom.ext.io.StreamCopyException;

final class MemoryBlobImpl
implements MemoryBlob {
    private MemoryBlobChunk firstChunk;
    private boolean committed;

    MemoryBlobImpl() {
    }

    public long getSize() {
        if (this.firstChunk == null || !this.committed) {
            throw new IllegalStateException();
        }
        long size = 0L;
        MemoryBlobChunk chunk = this.firstChunk;
        while (chunk != null) {
            size += (long)chunk.size;
            chunk = chunk.nextChunk;
        }
        return size;
    }

    public OutputStream getOutputStream() {
        return this.internalGetOutputStream();
    }

    private MemoryBlobOutputStream internalGetOutputStream() {
        if (this.firstChunk != null || this.committed) {
            throw new IllegalStateException();
        }
        this.firstChunk = new MemoryBlobChunk(4096);
        return new MemoryBlobOutputStream(this, this.firstChunk);
    }

    void commit() {
        this.committed = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long readFrom(InputStream in) throws StreamCopyException {
        MemoryBlobOutputStream out = this.internalGetOutputStream();
        try {
            long l = out.readFrom(in, -1L);
            return l;
        }
        finally {
            out.close();
        }
    }

    public InputStream getInputStream() {
        return this.getInputStream(true);
    }

    public InputStream readOnce() {
        return this.getInputStream(false);
    }

    public InputStream getInputStream(boolean preserve) {
        if (this.firstChunk == null || !this.committed) {
            throw new IllegalStateException();
        }
        MemoryBlobInputStream in = new MemoryBlobInputStream(this.firstChunk);
        if (!preserve) {
            this.firstChunk = null;
        }
        return in;
    }

    public void writeTo(OutputStream os) throws StreamCopyException {
        if (this.firstChunk == null || !this.committed) {
            throw new IllegalStateException();
        }
        MemoryBlobChunk chunk = this.firstChunk;
        try {
            while (chunk != null) {
                if (chunk.size > 0) {
                    os.write(chunk.buffer, 0, chunk.size);
                }
                chunk = chunk.nextChunk;
            }
        }
        catch (IOException ex) {
            throw new StreamCopyException(2, ex);
        }
    }

    public void release() {
        this.firstChunk = null;
    }
}

