/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.endpoints;

import java.util.ArrayList;
import java.util.List;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.synapse.MessageContext;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.core.axis2.Axis2SynapseEnvironment;
import org.apache.synapse.endpoints.AbstractEndpoint;
import org.apache.synapse.endpoints.Endpoint;
import org.apache.synapse.endpoints.LoadbalanceEndpoint;
import org.apache.synapse.endpoints.dispatch.Dispatcher;
import org.apache.synapse.endpoints.dispatch.HttpSessionDispatcher;
import org.apache.synapse.endpoints.dispatch.SALSessions;
import org.apache.synapse.endpoints.dispatch.SessionInformation;
import org.apache.synapse.transport.passthru.util.RelayUtils;

public class SALoadbalanceEndpoint
extends LoadbalanceEndpoint {
    private Dispatcher dispatcher = null;
    private long sessionTimeout = -1L;

    @Override
    public void init(SynapseEnvironment synapseEnvironment) {
        ConfigurationContext cc = ((Axis2SynapseEnvironment)synapseEnvironment).getAxis2ConfigurationContext();
        if (!this.initialized) {
            super.init(synapseEnvironment);
            SALSessions salSessions = SALSessions.getInstance();
            if (!salSessions.isInitialized()) {
                salSessions.initialize(this.isClusteringEnabled, cc);
            }
            if (this.isClusteringEnabled.booleanValue() && (this.getParentEndpoint() == null || !(this.getParentEndpoint() instanceof SALoadbalanceEndpoint))) {
                SALSessions.getInstance().registerChildren(this, this.getChildren());
            }
        }
    }

    @Override
    public void send(MessageContext synCtx) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Start : Session Affinity Load-balance Endpoint " + this.getName()));
        }
        SessionInformation sessionInformation = (SessionInformation)synCtx.getProperty("synapse.sal.endpoint.current.sessioninformation");
        List<Endpoint> endpoints = (List<Endpoint>)synCtx.getProperty("synapse.sal.current.endpoint.list");
        if (!(this.dispatcher instanceof HttpSessionDispatcher)) {
            try {
                RelayUtils.buildMessage((org.apache.axis2.context.MessageContext)((Axis2MessageContext)synCtx).getAxis2MessageContext(), (boolean)false);
            }
            catch (Exception e) {
                this.handleException("Error while building message", e);
            }
        }
        this.evaluateProperties(synCtx);
        if (sessionInformation == null && endpoints == null && (sessionInformation = this.dispatcher.getSession(synCtx)) != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Current session id : " + sessionInformation.getId()));
            }
            endpoints = this.dispatcher.getEndpoints(sessionInformation);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Endpoint sequence (path) on current session : " + this + endpoints));
            }
            synCtx.setProperty("synapse.sal.current.endpoint.list", endpoints);
            synCtx.setProperty("synapse.sal.endpoint.current.sessioninformation", sessionInformation);
        }
        if (sessionInformation != null && endpoints != null) {
            this.sendMessageOnCurrentSession(sessionInformation.getId(), endpoints, synCtx);
        } else {
            this.sendMessageOnNewSession(synCtx);
        }
    }

    public Dispatcher getDispatcher() {
        return this.dispatcher;
    }

    public void setDispatcher(Dispatcher dispatcher) {
        this.dispatcher = dispatcher;
    }

    @Override
    public void onChildEndpointFail(Endpoint endpoint, MessageContext synCtx) {
        this.logOnChildEndpointFail(endpoint, synCtx);
        Object o = synCtx.getProperty("synapse.sal.first_message_in_session");
        if (o != null && Boolean.TRUE.equals(o) && !((AbstractEndpoint)endpoint).isRetryDisabled(synCtx)) {
            List endpointList;
            this.dispatcher.unbind(synCtx);
            Object epListObj = synCtx.getProperty("synapse.sal.endpoint.list");
            if (epListObj instanceof List && !(endpointList = (List)epListObj).isEmpty()) {
                if (endpointList.get(0) == this) {
                    endpointList.clear();
                } else if (endpointList.contains(this)) {
                    int lastIndex = endpointList.indexOf(this);
                    List head = endpointList.subList(lastIndex, endpointList.size());
                    head.clear();
                }
            }
            this.send(synCtx);
        } else {
            this.informFailure(synCtx, 309003, "Failure an endpoint " + endpoint + "  in the current session");
        }
    }

    private void sendMessageOnCurrentSession(String sessionID, List<Endpoint> endpoints, MessageContext synCtx) {
        Endpoint endpoint = null;
        boolean invalidSequence = false;
        if (endpoints.isEmpty()) {
            invalidSequence = true;
        } else if (endpoints.contains(this)) {
            int length = endpoints.size();
            if (length > 1) {
                int beginIndex = endpoints.lastIndexOf(this) + 1;
                if (beginIndex == length) {
                    invalidSequence = true;
                } else if (!(endpoints = endpoints.subList(beginIndex, length)).isEmpty()) {
                    endpoint = endpoints.remove(0);
                } else {
                    invalidSequence = true;
                }
            } else {
                invalidSequence = true;
            }
        } else {
            endpoint = endpoints.remove(0);
        }
        if (invalidSequence) {
            this.informFailure(synCtx, 309002, "Invalid endpoint sequence " + endpoints + " for session with id " + sessionID);
            return;
        }
        if (endpoint != null && endpoint.readyToSend()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Using the endpoint " + endpoint + " for sending the message"));
            }
            synCtx.pushFaultHandler(this);
            endpoint.send(synCtx);
        } else {
            this.informFailure(synCtx, 309001, "The endpoint " + endpoint + " on the session with id " + sessionID + " is not ready.");
        }
    }

    private void sendMessageOnNewSession(MessageContext synCtx) {
        Endpoint endpoint = this.getNextChild(synCtx);
        if (endpoint == null) {
            this.informFailure(synCtx, 303000, "SLALoadbalance endpoint : " + this.getName() + " - no ready child endpoints");
        } else {
            this.prepareEndPointSequence(synCtx, endpoint);
            synCtx.getEnvelope().build();
            synCtx.setProperty("synapse.sal.first_message_in_session", Boolean.TRUE);
            synCtx.pushFaultHandler(this);
            endpoint.send(synCtx);
        }
    }

    private void prepareEndPointSequence(MessageContext synCtx, Endpoint endpoint) {
        ArrayList<SALoadbalanceEndpoint> endpointList;
        Object o = synCtx.getProperty("synapse.sal.endpoint.list");
        if (o instanceof List) {
            endpointList = (ArrayList<SALoadbalanceEndpoint>)o;
            endpointList.add(this);
        } else {
            endpointList = new ArrayList<SALoadbalanceEndpoint>();
            endpointList.add(this);
            synCtx.setProperty("synapse.sal.endpoint.list", endpointList);
            synCtx.setProperty("synape.sal.endpoints.dispatcher", this.dispatcher);
        }
        if (!(endpoint instanceof SALoadbalanceEndpoint)) {
            endpointList.add((SALoadbalanceEndpoint)endpoint);
            if (this.dispatcher.isServerInitiatedSession()) {
                this.dispatcher.removeSessionID(synCtx);
            }
        }
    }

    public long getSessionTimeout() {
        return this.sessionTimeout;
    }

    public void setSessionTimeout(long sessionTimeout) {
        this.sessionTimeout = sessionTimeout;
    }
}

