/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.controls;

import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.unboundidds.controls.ControlMessages;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import com.unboundid.util.json.JSONBoolean;
import com.unboundid.util.json.JSONNumber;
import com.unboundid.util.json.JSONObject;
import com.unboundid.util.json.JSONString;
import com.unboundid.util.json.JSONValue;
import java.io.Serializable;
import java.text.ParseException;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Objects;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class RecentLoginHistoryAttempt
implements Serializable,
Comparable<RecentLoginHistoryAttempt> {
    @NotNull
    private static final String JSON_FIELD_ADDITIONAL_ATTEMPT_COUNT = "additional-attempt-count";
    @NotNull
    private static final String JSON_FIELD_AUTHENTICATION_METHOD = "authentication-method";
    @NotNull
    private static final String JSON_FIELD_CLIENT_IP_ADDRESS = "client-ip-address";
    @NotNull
    private static final String JSON_FIELD_FAILURE_REASON = "failure-reason";
    @NotNull
    private static final String JSON_FIELD_SUCCESSFUL = "successful";
    @NotNull
    private static final String JSON_FIELD_TIMESTAMP = "timestamp";
    private static final long serialVersionUID = 6060214815221896077L;
    private final boolean successful;
    @NotNull
    private final JSONObject jsonObject;
    @Nullable
    private final Long additionalAttemptCount;
    private final long timestamp;
    @NotNull
    private final String authenticationMethod;
    @Nullable
    private final String clientIPAddress;
    @Nullable
    private final String failureReason;

    public RecentLoginHistoryAttempt(boolean successful, long timestamp, @NotNull String authenticationMethod, @Nullable String clientIPAddress, @Nullable String failureReason, @Nullable Long additionalAttemptCount) {
        Validator.ensureNotNullOrEmpty(authenticationMethod, "RecentLoginHistoryAttempt.<init>.authenticationMethod must not be null or empty.");
        if (successful) {
            Validator.ensureTrue(failureReason == null, "RecentLoginHistoryAttempt.<init>.failureReason must be null for successful authentication attempts.");
        } else {
            Validator.ensureNotNullOrEmpty(failureReason, "RecentLoginHistoryAttempt.<init>.failureReason must not be null or empty for failed authentication attempts.");
        }
        this.successful = successful;
        this.timestamp = timestamp;
        this.authenticationMethod = authenticationMethod;
        this.clientIPAddress = clientIPAddress;
        this.failureReason = failureReason;
        this.additionalAttemptCount = additionalAttemptCount;
        this.jsonObject = RecentLoginHistoryAttempt.encodeToJSON(successful, timestamp, authenticationMethod, clientIPAddress, failureReason, additionalAttemptCount);
    }

    public RecentLoginHistoryAttempt(@NotNull JSONObject jsonObject) throws LDAPException {
        Validator.ensureNotNull(jsonObject, "RecentLoginHistoryAttempt.<init>.jsonObject must not be null.");
        this.jsonObject = jsonObject;
        Boolean successfulBoolean = jsonObject.getFieldAsBoolean(JSON_FIELD_SUCCESSFUL);
        if (successfulBoolean == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_RECENT_LOGIN_HISTORY_ATTEMPT_MISSING_FIELD.get(jsonObject.toSingleLineString(), JSON_FIELD_SUCCESSFUL));
        }
        this.successful = successfulBoolean;
        String timestampValue = jsonObject.getFieldAsString(JSON_FIELD_TIMESTAMP);
        if (timestampValue == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_RECENT_LOGIN_HISTORY_ATTEMPT_MISSING_FIELD.get(jsonObject.toSingleLineString(), JSON_FIELD_TIMESTAMP));
        }
        try {
            this.timestamp = StaticUtils.decodeRFC3339Time(timestampValue).getTime();
        }
        catch (ParseException e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_RECENT_LOGIN_HISTORY_ATTEMPT_MALFORMED_TIMESTAMP.get(jsonObject.toSingleLineString(), timestampValue, e.getMessage()), e);
        }
        this.authenticationMethod = jsonObject.getFieldAsString(JSON_FIELD_AUTHENTICATION_METHOD);
        if (this.authenticationMethod == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_RECENT_LOGIN_HISTORY_ATTEMPT_MISSING_FIELD.get(jsonObject.toSingleLineString(), JSON_FIELD_AUTHENTICATION_METHOD));
        }
        this.clientIPAddress = jsonObject.getFieldAsString(JSON_FIELD_CLIENT_IP_ADDRESS);
        this.failureReason = jsonObject.getFieldAsString(JSON_FIELD_FAILURE_REASON);
        if (this.successful) {
            if (this.failureReason != null) {
                throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_RECENT_LOGIN_HISTORY_ATTEMPT_UNEXPECTED_FAILURE_REASON.get(jsonObject.toSingleLineString()));
            }
        } else if (this.failureReason == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_RECENT_LOGIN_HISTORY_ATTEMPT_MISSING_FAILURE_REASON.get(jsonObject.toSingleLineString(), JSON_FIELD_FAILURE_REASON));
        }
        this.additionalAttemptCount = jsonObject.getFieldAsLong(JSON_FIELD_ADDITIONAL_ATTEMPT_COUNT);
    }

    @NotNull
    private static JSONObject encodeToJSON(boolean successful, long timestamp, @NotNull String authenticationMethod, @Nullable String clientIPAddress, @Nullable String failureReason, @Nullable Long additionalAttemptCount) {
        LinkedHashMap<String, JSONValue> fields = new LinkedHashMap<String, JSONValue>(StaticUtils.computeMapCapacity(6));
        fields.put(JSON_FIELD_SUCCESSFUL, new JSONBoolean(successful));
        fields.put(JSON_FIELD_TIMESTAMP, new JSONString(StaticUtils.encodeRFC3339Time(timestamp)));
        fields.put(JSON_FIELD_AUTHENTICATION_METHOD, new JSONString(authenticationMethod));
        if (clientIPAddress != null) {
            fields.put(JSON_FIELD_CLIENT_IP_ADDRESS, new JSONString(clientIPAddress));
        }
        if (failureReason != null) {
            fields.put(JSON_FIELD_FAILURE_REASON, new JSONString(failureReason));
        }
        if (additionalAttemptCount != null) {
            fields.put(JSON_FIELD_ADDITIONAL_ATTEMPT_COUNT, new JSONNumber(additionalAttemptCount));
        }
        return new JSONObject(fields);
    }

    public boolean isSuccessful() {
        return this.successful;
    }

    @NotNull
    public Date getTimestamp() {
        return new Date(this.timestamp);
    }

    @NotNull
    public String getAuthenticationMethod() {
        return this.authenticationMethod;
    }

    @Nullable
    public String getClientIPAddress() {
        return this.clientIPAddress;
    }

    @Nullable
    public String getFailureReason() {
        return this.failureReason;
    }

    @Nullable
    public Long getAdditionalAttemptCount() {
        return this.additionalAttemptCount;
    }

    @NotNull
    public JSONObject asJSONObject() {
        return this.jsonObject;
    }

    public boolean equals(@Nullable Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (!(o instanceof RecentLoginHistoryAttempt)) {
            return false;
        }
        RecentLoginHistoryAttempt a = (RecentLoginHistoryAttempt)o;
        if (this.successful != a.successful) {
            return false;
        }
        if (this.timestamp != a.timestamp) {
            return false;
        }
        if (!this.authenticationMethod.equalsIgnoreCase(a.authenticationMethod)) {
            return false;
        }
        if (!Objects.equals(this.clientIPAddress, a.clientIPAddress)) {
            return false;
        }
        if (!Objects.equals(this.failureReason, a.failureReason)) {
            return false;
        }
        return Objects.equals(this.additionalAttemptCount, a.additionalAttemptCount);
    }

    public int hashCode() {
        int hashCode = this.successful ? 1 : 0;
        hashCode += (int)this.timestamp;
        hashCode += StaticUtils.toLowerCase(this.authenticationMethod).hashCode();
        if (this.clientIPAddress != null) {
            hashCode += StaticUtils.toLowerCase(this.clientIPAddress).hashCode();
        }
        if (this.failureReason != null) {
            hashCode += StaticUtils.toLowerCase(this.failureReason).hashCode();
        }
        if (this.additionalAttemptCount != null) {
            hashCode += this.additionalAttemptCount.hashCode();
        }
        return hashCode;
    }

    @Override
    public int compareTo(@NotNull RecentLoginHistoryAttempt a) {
        if (this.timestamp > a.timestamp) {
            return -1;
        }
        if (this.timestamp < a.timestamp) {
            return 1;
        }
        if (this.successful != a.successful) {
            if (this.successful) {
                return -1;
            }
            return 1;
        }
        if (!this.authenticationMethod.equalsIgnoreCase(a.authenticationMethod)) {
            return StaticUtils.toLowerCase(this.authenticationMethod).compareTo(StaticUtils.toLowerCase(a.authenticationMethod));
        }
        if (this.additionalAttemptCount == null) {
            if (a.additionalAttemptCount != null) {
                return 1;
            }
        } else {
            if (a.additionalAttemptCount == null) {
                return -1;
            }
            if (this.additionalAttemptCount > a.additionalAttemptCount) {
                return -1;
            }
            if (this.additionalAttemptCount < a.additionalAttemptCount) {
                return 1;
            }
        }
        if (this.clientIPAddress == null) {
            if (a.clientIPAddress != null) {
                return 1;
            }
        } else {
            if (a.clientIPAddress == null) {
                return -1;
            }
            if (!this.clientIPAddress.equalsIgnoreCase(a.clientIPAddress)) {
                return StaticUtils.toLowerCase(this.clientIPAddress).compareTo(StaticUtils.toLowerCase(a.clientIPAddress));
            }
        }
        if (this.failureReason != null && !this.failureReason.equalsIgnoreCase(a.failureReason)) {
            return StaticUtils.toLowerCase(this.failureReason).compareTo(StaticUtils.toLowerCase(a.failureReason));
        }
        return 0;
    }

    @NotNull
    public String toString() {
        return this.jsonObject.toSingleLineString();
    }
}

