/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oauth.client;

import org.pac4j.core.client.IndirectClient;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.oauth.config.OAuth10Configuration;
import org.pac4j.oauth.credentials.authenticator.OAuth10Authenticator;
import org.pac4j.oauth.credentials.extractor.OAuth10CredentialsExtractor;
import org.pac4j.oauth.profile.creator.OAuth10ProfileCreator;
import org.pac4j.oauth.redirect.OAuth10RedirectionActionBuilder;

public class OAuth10Client
extends IndirectClient {
    protected OAuth10Configuration configuration = new OAuth10Configuration();

    protected void beforeInternalInit(boolean forceReinit) {
        super.beforeInternalInit(forceReinit);
        CommonHelper.assertNotNull((String)"configuration", (Object)((Object)this.configuration));
    }

    protected void internalInit(boolean forceReinit) {
        this.defaultRedirectionActionBuilder(new OAuth10RedirectionActionBuilder(this.configuration, this));
        this.defaultCredentialsExtractor(new OAuth10CredentialsExtractor(this.configuration, (IndirectClient)this));
        this.defaultAuthenticator(new OAuth10Authenticator(this.configuration, (IndirectClient)this));
        this.defaultProfileCreator(new OAuth10ProfileCreator(this.configuration, (IndirectClient)this));
    }

    public OAuth10Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(OAuth10Configuration configuration) {
        this.configuration = configuration;
    }

    public String getKey() {
        return this.configuration.getKey();
    }

    public void setKey(String key) {
        this.configuration.setKey(key);
    }

    public String getSecret() {
        return this.configuration.getSecret();
    }

    public void setSecret(String secret) {
        this.configuration.setSecret(secret);
    }

    public String toString() {
        return CommonHelper.toNiceString(((Object)((Object)this)).getClass(), (Object[])new Object[]{"name", this.getName(), "callbackUrl", this.getCallbackUrl(), "callbackUrlResolver", this.getCallbackUrlResolver(), "ajaxRequestResolver", this.getAjaxRequestResolver(), "redirectionActionBuilder", this.getRedirectionActionBuilder(), "credentialsExtractor", this.getCredentialsExtractor(), "authenticator", this.getAuthenticator(), "profileCreator", this.getProfileCreator(), "configuration", this.configuration});
    }
}

