/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.form;

import java.util.List;
import org.apache.wicket.Application;
import org.apache.wicket.ajax.WicketAjaxJQueryResourceReference;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.markup.head.OnLoadHeaderItem;
import org.apache.wicket.markup.html.IHeaderContributor;
import org.apache.wicket.markup.html.form.LabeledWebMarkupContainer;
import org.apache.wicket.request.resource.JavaScriptResourceReference;
import org.apache.wicket.request.resource.ResourceReference;

public abstract class AbstractCheckSelector
extends LabeledWebMarkupContainer
implements IHeaderContributor {
    private static final long serialVersionUID = 1L;
    private static final ResourceReference JS = new JavaScriptResourceReference((Class)AbstractCheckSelector.class, "CheckSelector.js"){
        private static final long serialVersionUID = 1L;

        @Override
        public List<HeaderItem> getDependencies() {
            List<HeaderItem> dependencies = super.getDependencies();
            ResourceReference wicketEventReference = WicketAjaxJQueryResourceReference.get();
            if (Application.exists()) {
                wicketEventReference = Application.get().getJavaScriptLibrarySettings().getWicketAjaxReference();
            }
            dependencies.add(JavaScriptHeaderItem.forReference(wicketEventReference));
            return dependencies;
        }
    };

    public AbstractCheckSelector(String id) {
        super(id);
        this.setOutputMarkupId(true);
    }

    protected boolean wantAutomaticUpdate() {
        return true;
    }

    @Override
    public void renderHead(IHeaderResponse response) {
        response.render(JavaScriptHeaderItem.forReference(JS));
        String findCheckboxes = this.getFindCheckboxesFunction().toString();
        response.render(OnLoadHeaderItem.forScript("Wicket.CheckboxSelector.initializeSelector('" + this.getMarkupId() + "', " + findCheckboxes + ");"));
        if (this.wantAutomaticUpdate()) {
            response.render(OnLoadHeaderItem.forScript("Wicket.CheckboxSelector.attachUpdateHandlers('" + this.getMarkupId() + "', " + findCheckboxes + ");"));
        }
    }

    @Override
    protected void onComponentTag(ComponentTag tag) {
        super.onComponentTag(tag);
        if (this.isEnableAllowed() && this.isEnabledInHierarchy()) {
            tag.remove("disabled");
        } else {
            tag.put("disabled", "disabled");
        }
        this.checkComponentTag(tag, "input");
        this.checkComponentTagAttribute(tag, "type", "checkbox");
    }

    protected abstract CharSequence getFindCheckboxesFunction();
}

