/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.security.trust.impl;

import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.annotation.ParameterName;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotLive;
import net.shibboleth.utilities.java.support.annotation.constraint.Unmodifiable;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import org.opensaml.security.SecurityException;
import org.opensaml.security.trust.TrustEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChainingTrustEngine<TokenType>
implements TrustEngine<TokenType> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ChainingTrustEngine.class);
    @Nonnull
    @NonnullElements
    private List<TrustEngine<? super TokenType>> engines;

    public ChainingTrustEngine(@Nonnull @ParameterName(name="chain") @NonnullElements List<TrustEngine<? super TokenType>> chain) {
        this.engines = List.copyOf((Collection)Constraint.isNotNull(chain, (String)"TrustEngine list cannot be null"));
    }

    @Nonnull
    @NonnullElements
    @Unmodifiable
    @NotLive
    public List<TrustEngine<? super TokenType>> getChain() {
        return this.engines;
    }

    public boolean validate(@Nonnull TokenType token, @Nullable CriteriaSet trustBasisCriteria) throws SecurityException {
        for (TrustEngine<? super TokenType> trustEngine : this.engines) {
            if (!trustEngine.validate(token, trustBasisCriteria)) continue;
            this.log.debug("Token was trusted by chain member: {}", (Object)trustEngine.getClass().getName());
            return true;
        }
        return false;
    }
}

