/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.batch.service;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.flowable.batch.api.BatchService;
import org.flowable.batch.service.impl.BatchServiceImpl;
import org.flowable.batch.service.impl.persistence.entity.BatchEntityManager;
import org.flowable.batch.service.impl.persistence.entity.BatchEntityManagerImpl;
import org.flowable.batch.service.impl.persistence.entity.BatchPartEntityManager;
import org.flowable.batch.service.impl.persistence.entity.BatchPartEntityManagerImpl;
import org.flowable.batch.service.impl.persistence.entity.data.BatchDataManager;
import org.flowable.batch.service.impl.persistence.entity.data.BatchPartDataManager;
import org.flowable.batch.service.impl.persistence.entity.data.impl.MybatisBatchDataManager;
import org.flowable.batch.service.impl.persistence.entity.data.impl.MybatisBatchPartDataManager;
import org.flowable.common.engine.impl.AbstractServiceConfiguration;

public class BatchServiceConfiguration
extends AbstractServiceConfiguration {
    protected BatchService batchService = new BatchServiceImpl(this);
    protected BatchDataManager batchDataManager;
    protected BatchPartDataManager batchPartDataManager;
    protected BatchEntityManager batchEntityManager;
    protected BatchPartEntityManager batchPartEntityManager;
    protected ObjectMapper objectMapper;

    public BatchServiceConfiguration(String engineName) {
        super(engineName);
    }

    public void init() {
        this.initDataManagers();
        this.initEntityManagers();
    }

    public void initDataManagers() {
        if (this.batchDataManager == null) {
            this.batchDataManager = new MybatisBatchDataManager(this);
        }
        if (this.batchPartDataManager == null) {
            this.batchPartDataManager = new MybatisBatchPartDataManager(this);
        }
    }

    public void initEntityManagers() {
        if (this.batchEntityManager == null) {
            this.batchEntityManager = new BatchEntityManagerImpl(this, this.batchDataManager);
        }
        if (this.batchPartEntityManager == null) {
            this.batchPartEntityManager = new BatchPartEntityManagerImpl(this, this.batchPartDataManager);
        }
    }

    public BatchServiceConfiguration getIdentityLinkServiceConfiguration() {
        return this;
    }

    public BatchService getBatchService() {
        return this.batchService;
    }

    public BatchServiceConfiguration setBatchService(BatchService batchService) {
        this.batchService = batchService;
        return this;
    }

    public BatchDataManager getBatchDataManager() {
        return this.batchDataManager;
    }

    public BatchServiceConfiguration setBatchDataManager(BatchDataManager batchDataManager) {
        this.batchDataManager = batchDataManager;
        return this;
    }

    public BatchPartDataManager getBatchPartDataManager() {
        return this.batchPartDataManager;
    }

    public BatchServiceConfiguration setBatchPartDataManager(BatchPartDataManager batchPartDataManager) {
        this.batchPartDataManager = batchPartDataManager;
        return this;
    }

    public BatchEntityManager getBatchEntityManager() {
        return this.batchEntityManager;
    }

    public BatchServiceConfiguration setBatchEntityManager(BatchEntityManager batchEntityManager) {
        this.batchEntityManager = batchEntityManager;
        return this;
    }

    public BatchPartEntityManager getBatchPartEntityManager() {
        return this.batchPartEntityManager;
    }

    public BatchServiceConfiguration setBatchPartEntityManager(BatchPartEntityManager batchPartEntityManager) {
        this.batchPartEntityManager = batchPartEntityManager;
        return this;
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public BatchServiceConfiguration setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
        return this;
    }
}

