/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.web.views;

import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.bval.util.StringUtils;
import org.apereo.cas.configuration.model.support.oauth.OAuthCoreProperties;
import org.apereo.cas.configuration.model.support.oauth.OAuthProperties;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.util.OAuth20Utils;
import org.apereo.cas.support.oauth.web.views.OAuth20UserProfileViewRenderer;
import org.apereo.cas.ticket.accesstoken.OAuth20AccessToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;

public class OAuth20DefaultUserProfileViewRenderer
implements OAuth20UserProfileViewRenderer {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OAuth20DefaultUserProfileViewRenderer.class);
    protected final ServicesManager servicesManager;
    private final OAuthProperties oauthProperties;

    @Override
    public ResponseEntity render(Map<String, Object> model, OAuth20AccessToken accessToken, HttpServletResponse response) {
        Map<String, Object> userProfile = this.getRenderedUserProfile(model, accessToken, response);
        return this.renderProfileForModel(userProfile, accessToken, response);
    }

    protected ResponseEntity renderProfileForModel(Map<String, Object> userProfile, OAuth20AccessToken accessToken, HttpServletResponse response) {
        String json = OAuth20Utils.toJson(userProfile);
        LOGGER.debug("Final user profile is [{}]", (Object)json);
        return new ResponseEntity((Object)json, HttpStatus.OK);
    }

    protected Map<String, Object> getRenderedUserProfile(Map<String, Object> model, OAuth20AccessToken accessToken, HttpServletResponse response) {
        OAuthRegisteredService registeredService = OAuth20Utils.getRegisteredOAuthServiceByClientId(this.servicesManager, accessToken.getClientId());
        OAuthCoreProperties.UserProfileViewTypes type = this.oauthProperties.getCore().getUserProfileViewType();
        if (registeredService != null && StringUtils.isNotBlank((CharSequence)registeredService.getUserProfileViewType())) {
            type = OAuthCoreProperties.UserProfileViewTypes.valueOf((String)registeredService.getUserProfileViewType().toUpperCase());
        }
        LOGGER.debug("User profile view type for client [{}] is set to [{}]", (Object)accessToken.getClientId(), (Object)type);
        if (type == OAuthCoreProperties.UserProfileViewTypes.FLAT) {
            LinkedHashMap<String, Object> flattened = new LinkedHashMap<String, Object>();
            if (model.containsKey("attributes")) {
                Map attributes = (Map)Map.class.cast(model.get("attributes"));
                flattened.putAll(attributes);
            }
            model.keySet().stream().filter(k -> !k.equalsIgnoreCase("attributes")).forEach(k -> flattened.put((String)k, model.get(k)));
            LOGGER.trace("Flattened user profile attributes with the final model as [{}]", model);
            return flattened;
        }
        return model;
    }

    @Generated
    public OAuth20DefaultUserProfileViewRenderer(ServicesManager servicesManager, OAuthProperties oauthProperties) {
        this.servicesManager = servicesManager;
        this.oauthProperties = oauthProperties;
    }
}

