/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.dao;

import java.sql.Clob;
import java.sql.SQLException;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.common.lib.audit.AuditEntry;
import org.apache.syncope.common.lib.types.AuditElements;
import org.apache.syncope.core.persistence.api.dao.AuditConfDAO;
import org.apache.syncope.core.persistence.api.dao.search.OrderByClause;
import org.apache.syncope.core.persistence.api.entity.AuditConf;
import org.apache.syncope.core.persistence.jpa.dao.AbstractDAO;
import org.apache.syncope.core.persistence.jpa.entity.JPAAuditConf;
import org.apache.syncope.core.provisioning.api.serialization.POJOHelper;
import org.springframework.transaction.annotation.Transactional;

public class JPAAuditConfDAO
extends AbstractDAO<AuditConf>
implements AuditConfDAO {
    public AuditConf find(String key) {
        return (AuditConf)this.entityManager().find(JPAAuditConf.class, (Object)key);
    }

    public List<AuditConf> findAll() {
        TypedQuery query = this.entityManager().createQuery("SELECT e FROM " + JPAAuditConf.class.getSimpleName() + " e ", AuditConf.class);
        return query.getResultList();
    }

    public AuditConf save(AuditConf auditConf) {
        return (AuditConf)this.entityManager().merge((Object)auditConf);
    }

    public void delete(AuditConf auditConf) {
        this.entityManager().remove((Object)auditConf);
    }

    protected MessageCriteriaBuilder messageCriteriaBuilder(String entityKey) {
        return new MessageCriteriaBuilder().entityKey(entityKey);
    }

    protected void fillWithParameters(Query query, List<Object> parameters) {
        for (int i = 0; i < parameters.size(); ++i) {
            if (parameters.get(i) instanceof Boolean) {
                query.setParameter(i + 1, (Object)((Boolean)parameters.get(i) != false ? 1 : 0));
                continue;
            }
            query.setParameter(i + 1, parameters.get(i));
        }
    }

    public int countEntries(String entityKey, AuditElements.EventCategoryType type, String category, String subcategory, List<String> events, AuditElements.Result result, OffsetDateTime before, OffsetDateTime after) {
        ArrayList<Object> parameters = new ArrayList<Object>();
        String queryString = "SELECT COUNT(0) FROM AuditEntry WHERE " + this.messageCriteriaBuilder(entityKey).type(type).category(category).subcategory(subcategory).result(result).events(events).before(before, parameters).after(after, parameters).build();
        Query query = this.entityManager().createNativeQuery(queryString);
        this.fillWithParameters(query, parameters);
        return ((Number)query.getSingleResult()).intValue();
    }

    protected String select() {
        return "MESSAGE";
    }

    @Transactional(readOnly=true)
    public List<AuditEntry> searchEntries(String entityKey, int page, int itemsPerPage, AuditElements.EventCategoryType type, String category, String subcategory, List<String> events, AuditElements.Result result, OffsetDateTime before, OffsetDateTime after, List<OrderByClause> orderBy) {
        ArrayList<Object> parameters = new ArrayList<Object>();
        String queryString = "SELECT " + this.select() + " FROM AuditEntry WHERE " + this.messageCriteriaBuilder(entityKey).type(type).category(category).subcategory(subcategory).result(result).events(events).before(before, parameters).after(after, parameters).build();
        if (!orderBy.isEmpty()) {
            queryString = queryString + " ORDER BY " + orderBy.stream().map(clause -> clause.getField() + " " + clause.getDirection().name()).collect(Collectors.joining(","));
        }
        Query query = this.entityManager().createNativeQuery(queryString);
        this.fillWithParameters(query, parameters);
        query.setFirstResult(itemsPerPage * (page <= 0 ? 0 : page - 1));
        if (itemsPerPage >= 0) {
            query.setMaxResults(itemsPerPage);
        }
        List entries = query.getResultList();
        return entries.stream().map(row -> {
            String value;
            if (row instanceof Clob) {
                Clob clob = (Clob)row;
                try {
                    value = clob.getSubString(1L, (int)clob.length());
                }
                catch (SQLException e) {
                    LOG.error("Unexpected error reading Audit Entry for entity key {}", (Object)entityKey, (Object)e);
                    return null;
                }
            } else {
                value = row.toString();
            }
            return (AuditEntry)POJOHelper.deserialize((String)value, AuditEntry.class);
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    protected static class MessageCriteriaBuilder {
        protected final StringBuilder query = new StringBuilder();

        protected MessageCriteriaBuilder() {
        }

        protected String andIfNeeded() {
            return this.query.length() == 0 ? " " : " AND ";
        }

        protected int setParameter(List<Object> parameters, Object parameter) {
            parameters.add(parameter);
            return parameters.size();
        }

        protected MessageCriteriaBuilder entityKey(String entityKey) {
            if (entityKey != null) {
                this.query.append(this.andIfNeeded()).append("MESSAGE").append(" LIKE '%key%").append(entityKey).append("%'");
            }
            return this;
        }

        public MessageCriteriaBuilder type(AuditElements.EventCategoryType type) {
            if (type != null) {
                this.query.append(this.andIfNeeded()).append("MESSAGE").append(" LIKE '%\"type\":\"").append(type.name()).append("\"%'");
            }
            return this;
        }

        public MessageCriteriaBuilder category(String category) {
            if (StringUtils.isNotBlank((CharSequence)category)) {
                this.query.append(this.andIfNeeded()).append("MESSAGE").append(" LIKE '%\"category\":\"").append(category).append("\"%'");
            }
            return this;
        }

        public MessageCriteriaBuilder subcategory(String subcategory) {
            if (StringUtils.isNotBlank((CharSequence)subcategory)) {
                this.query.append(this.andIfNeeded()).append("MESSAGE").append(" LIKE '%\"subcategory\":\"").append(subcategory).append("\"%'");
            }
            return this;
        }

        public MessageCriteriaBuilder events(List<String> events) {
            if (!events.isEmpty()) {
                this.query.append(this.andIfNeeded()).append("( ").append(events.stream().map(event -> "MESSAGE LIKE '%\"event\":\"" + event + "\"%'").collect(Collectors.joining(" OR "))).append(" )");
            }
            return this;
        }

        public MessageCriteriaBuilder result(AuditElements.Result result) {
            if (result != null) {
                this.query.append(this.andIfNeeded()).append("MESSAGE").append(" LIKE '%\"result\":\"").append(result.name()).append("\"%' ");
            }
            return this;
        }

        public MessageCriteriaBuilder before(OffsetDateTime before, List<Object> parameters) {
            if (before != null) {
                this.query.append(this.andIfNeeded()).append("EVENT_DATE").append(" <= ?").append(this.setParameter(parameters, before));
            }
            return this;
        }

        public MessageCriteriaBuilder after(OffsetDateTime after, List<Object> parameters) {
            if (after != null) {
                this.query.append(this.andIfNeeded()).append("EVENT_DATE").append(" >= ?").append(this.setParameter(parameters, after));
            }
            return this;
        }

        public String build() {
            return this.query.toString();
        }
    }
}

