/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.history.logging.proto;

import com.google.protobuf.MessageLite;
import com.google.protobuf.Parser;
import java.io.IOException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.yarn.util.Clock;
import org.apache.tez.dag.history.logging.proto.ProtoMessageReader;
import org.apache.tez.dag.history.logging.proto.ProtoMessageWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatePartitionedLogger<T extends MessageLite> {
    private static final Logger LOG = LoggerFactory.getLogger(DatePartitionedLogger.class);
    private static final FsPermission DIR_PERMISSION = FsPermission.createImmutable((short)1023);
    private static final FsPermission FILE_UMASK = FsPermission.createImmutable((short)54);
    private final Parser<T> parser;
    private final Path basePath;
    private final Configuration conf;
    private final Clock clock;

    public DatePartitionedLogger(Parser<T> parser, Path baseDir, Configuration conf, Clock clock) throws IOException {
        this.conf = new Configuration(conf);
        this.clock = clock;
        this.parser = parser;
        this.createDirIfNotExists(baseDir);
        this.basePath = baseDir.getFileSystem(conf).resolvePath(baseDir);
        FsPermission.setUMask((Configuration)this.conf, (FsPermission)FILE_UMASK);
    }

    private void createDirIfNotExists(Path path) throws IOException {
        FileSystem fileSystem = path.getFileSystem(this.conf);
        try {
            if (!fileSystem.exists(path)) {
                fileSystem.mkdirs(path);
                fileSystem.setPermission(path, DIR_PERMISSION);
            }
        }
        catch (IOException e) {
            LOG.warn("Error while trying to set permission: ", (Throwable)e);
        }
    }

    public ProtoMessageWriter<T> getWriter(String fileName) throws IOException {
        Path filePath = this.getPathForDate(this.getNow().toLocalDate(), fileName);
        return new ProtoMessageWriter<T>(this.conf, filePath, this.parser);
    }

    public ProtoMessageReader<T> getReader(Path filePath) throws IOException {
        return new ProtoMessageReader<T>(this.conf, filePath, this.parser);
    }

    public Path getPathForDate(LocalDate date, String fileName) throws IOException {
        Path path = new Path(this.basePath, this.getDirForDate(date));
        this.createDirIfNotExists(path);
        return new Path(path, fileName);
    }

    public Path getPathForSubdir(String dirName, String fileName) {
        return new Path(new Path(this.basePath, dirName), fileName);
    }

    public LocalDate getDateFromDir(String dirName) {
        if (!dirName.startsWith("date=")) {
            throw new IllegalArgumentException("Invalid directory: " + dirName);
        }
        return LocalDate.parse(dirName.substring(5), DateTimeFormatter.ISO_LOCAL_DATE);
    }

    public String getDirForDate(LocalDate date) {
        return "date=" + DateTimeFormatter.ISO_LOCAL_DATE.format(date);
    }

    public String getNextDirectory(String currentDir) throws IOException {
        String nextDate = this.getDirForDate(this.getDateFromDir(currentDir).plusDays(1L));
        FileSystem fileSystem = this.basePath.getFileSystem(this.conf);
        if (fileSystem.exists(new Path(this.basePath, nextDate))) {
            return nextDate;
        }
        String dirName = null;
        RemoteIterator iter = fileSystem.listStatusIterator(this.basePath);
        while (iter.hasNext()) {
            FileStatus status = (FileStatus)iter.next();
            String name = status.getPath().getName();
            if (name.compareTo(currentDir) <= 0 || dirName != null && name.compareTo(dirName) >= 0) continue;
            dirName = name;
        }
        return dirName;
    }

    public List<FileStatus> scanForChangedFiles(String subDir, Map<String, Long> currentOffsets) throws IOException {
        Path dirPath = new Path(this.basePath, subDir);
        FileSystem fileSystem = this.basePath.getFileSystem(this.conf);
        ArrayList<FileStatus> newFiles = new ArrayList<FileStatus>();
        if (!fileSystem.exists(dirPath)) {
            return newFiles;
        }
        RemoteIterator iter = fileSystem.listStatusIterator(dirPath);
        while (iter.hasNext()) {
            FileStatus status = (FileStatus)iter.next();
            String fileName = status.getPath().getName();
            Long offset = currentOffsets.get(fileName);
            if (offset != null && offset >= status.getLen()) continue;
            newFiles.add(status);
        }
        return newFiles;
    }

    public LocalDateTime getNow() {
        return LocalDateTime.ofEpochSecond(this.clock.getTime() / 1000L, 0, ZoneOffset.UTC);
    }

    public Configuration getConfig() {
        return this.conf;
    }
}

