/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.app.dag.impl;

import java.util.HashSet;
import java.util.Set;
import org.apache.tez.dag.app.dag.Vertex;

public class VertexShuffleDataDeletionContext {
    private int deletionHeight;
    private int incompleteChildrenVertices;
    private Set<Vertex> ancestors;
    private Set<Vertex> children;

    public VertexShuffleDataDeletionContext(int deletionHeight) {
        this.deletionHeight = deletionHeight;
        this.incompleteChildrenVertices = 0;
        this.ancestors = new HashSet<Vertex>();
        this.children = new HashSet<Vertex>();
    }

    public void setSpannedVertices(Vertex vertex) {
        VertexShuffleDataDeletionContext.getSpannedVerticesAncestors(vertex, this.ancestors, this.deletionHeight);
        VertexShuffleDataDeletionContext.getSpannedVerticesChildren(vertex, this.children, this.deletionHeight);
        this.setIncompleteChildrenVertices(this.children.size());
    }

    private static void getSpannedVerticesAncestors(Vertex vertex, Set<Vertex> ancestorVertices, int level) {
        if (level == 0) {
            ancestorVertices.add(vertex);
            return;
        }
        if (level == 1) {
            ancestorVertices.addAll(vertex.getInputVertices().keySet());
            return;
        }
        vertex.getInputVertices().forEach((inVertex, edge) -> VertexShuffleDataDeletionContext.getSpannedVerticesAncestors(inVertex, ancestorVertices, level - 1));
    }

    private static void getSpannedVerticesChildren(Vertex vertex, Set<Vertex> childVertices, int level) {
        if (level == 0) {
            childVertices.add(vertex);
            return;
        }
        if (level == 1) {
            childVertices.addAll(vertex.getOutputVertices().keySet());
            return;
        }
        vertex.getOutputVertices().forEach((outVertex, edge) -> VertexShuffleDataDeletionContext.getSpannedVerticesChildren(outVertex, childVertices, level - 1));
    }

    public void setIncompleteChildrenVertices(int incompleteChildrenVertices) {
        this.incompleteChildrenVertices = incompleteChildrenVertices;
    }

    public int getIncompleteChildrenVertices() {
        return this.incompleteChildrenVertices;
    }

    public Set<Vertex> getAncestors() {
        return this.ancestors;
    }

    public Set<Vertex> getChildren() {
        return this.children;
    }
}

