/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.mapreduce.examples;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.api.records.LocalResourceType;
import org.apache.hadoop.yarn.api.records.LocalResourceVisibility;
import org.apache.hadoop.yarn.api.records.URL;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.tez.client.TezClient;
import org.apache.tez.dag.api.DAG;
import org.apache.tez.dag.api.ProcessorDescriptor;
import org.apache.tez.dag.api.TezConfiguration;
import org.apache.tez.dag.api.TezException;
import org.apache.tez.dag.api.UserPayload;
import org.apache.tez.dag.api.Vertex;
import org.apache.tez.examples.TezExampleBase;
import org.apache.tez.runtime.api.ProcessorContext;
import org.apache.tez.runtime.library.processor.SimpleProcessor;
import org.apache.tez.util.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RPCLoadGen
extends TezExampleBase {
    private static final Logger LOG = LoggerFactory.getLogger(RPCLoadGen.class);
    private static final String VIA_RPC = "viaRpc";
    private static final byte VIA_RPC_BYTE = 0;
    private static final String VIA_HDFS_DIST_CACHE = "viaHdfsDistCache";
    private static final byte VIA_HDFS_DIST_CACHE_BYTE = 1;
    private static final String VIA_HDFS_DIRECT_READ = "viaHdfsDirectRead";
    private static final byte VIA_HDFS_DIRECT_READ_BYTE = 2;
    private static final Random random = new Random();
    private static final String DISK_PAYLOAD_NAME = RPCLoadGen.class.getSimpleName() + "_payload";
    private FileSystem fs;
    private Path resourcePath;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final int runJob(String[] args, TezConfiguration tezConf, TezClient tezClient) throws TezException, InterruptedException, IOException {
        LOG.info("Running: " + ((Object)((Object)this)).getClass().getSimpleName());
        String mode = VIA_RPC;
        if (args.length == 4) {
            if (args[3].equals(VIA_RPC) || args[3].equals(VIA_HDFS_DIRECT_READ) || args[3].equals(VIA_HDFS_DIST_CACHE)) {
                mode = args[3];
            } else {
                this.printUsage();
                return 2;
            }
        }
        int numTasks = Integer.parseInt(args[0]);
        int maxSleepTimeMillis = Integer.parseInt(args[1]);
        int payloadSizeBytes = Integer.parseInt(args[2]);
        LOG.info("Parameters: numTasks=" + numTasks + ", maxSleepTime(ms)=" + maxSleepTimeMillis + ", payloadSize(bytes)=" + payloadSizeBytes + ", mode=" + mode);
        DAG dag = this.createDAG(tezConf, numTasks, maxSleepTimeMillis, payloadSizeBytes, mode);
        try {
            int n = this.runDag(dag, false, LOG);
            return n;
        }
        finally {
            if (this.fs != null && this.resourcePath != null) {
                this.fs.delete(this.resourcePath, false);
            }
        }
    }

    protected void printUsage() {
        System.err.println("Usage: RPCLoadGen <numTasks> <max_sleep_time_millis> <get_task_payload_size> [<viaRpc>|viaHdfsDistCache|viaHdfsDirectRead]");
        ToolRunner.printGenericCommandUsage((PrintStream)System.err);
    }

    protected final int validateArgs(String[] otherArgs) {
        return otherArgs.length >= 3 && otherArgs.length <= 4 ? 0 : 2;
    }

    private DAG createDAG(TezConfiguration conf, int numTasks, int maxSleepTimeMillis, int payloadSize, String mode) throws IOException {
        HashMap<String, LocalResource> localResourceMap = new HashMap<String, LocalResource>();
        UserPayload payload = this.createUserPayload(conf, maxSleepTimeMillis, payloadSize, mode, localResourceMap);
        Vertex vertex = Vertex.create((String)"RPCLoadVertex", (ProcessorDescriptor)((ProcessorDescriptor)ProcessorDescriptor.create((String)RPCSleepProcessor.class.getName()).setUserPayload(payload)), (int)numTasks).addTaskLocalFiles(localResourceMap);
        return DAG.create((String)"RPCLoadGen").addVertex(vertex);
    }

    private UserPayload createUserPayload(TezConfiguration conf, int maxSleepTimeMillis, int payloadSize, String mode, Map<String, LocalResource> localResources) throws IOException {
        ByteBuffer payload;
        if (mode.equals(VIA_RPC)) {
            if (payloadSize < 5) {
                payloadSize = 5;
            }
            byte[] payloadBytes = new byte[payloadSize];
            random.nextBytes(payloadBytes);
            payload = ByteBuffer.wrap(payloadBytes);
            payload.put(4, (byte)0);
        } else {
            byte[] payloadBytes = new byte[5];
            payload = ByteBuffer.wrap(payloadBytes);
            byte[] diskPayload = new byte[payloadSize];
            random.nextBytes(diskPayload);
            this.fs = FileSystem.get((Configuration)conf);
            this.resourcePath = new Path("/tmp", DISK_PAYLOAD_NAME);
            this.resourcePath = this.fs.makeQualified(this.resourcePath);
            FSDataOutputStream dataOut = this.fs.create(this.resourcePath, true);
            dataOut.write(diskPayload);
            dataOut.close();
            this.fs.setReplication(this.resourcePath, (short)10);
            FileStatus fileStatus = this.fs.getFileStatus(this.resourcePath);
            if (mode.equals(VIA_HDFS_DIST_CACHE)) {
                LocalResource lr = LocalResource.newInstance((URL)ConverterUtils.getYarnUrlFromPath((Path)this.resourcePath), (LocalResourceType)LocalResourceType.FILE, (LocalResourceVisibility)LocalResourceVisibility.PRIVATE, (long)fileStatus.getLen(), (long)fileStatus.getModificationTime());
                localResources.put(DISK_PAYLOAD_NAME, lr);
                payload.put(4, (byte)1);
            } else if (mode.equals(VIA_HDFS_DIRECT_READ)) {
                payload.put(4, (byte)2);
            }
        }
        payload.putInt(0, maxSleepTimeMillis);
        return UserPayload.create((ByteBuffer)payload);
    }

    public static void main(String[] args) throws Exception {
        int res = ToolRunner.run((Configuration)new Configuration(), (Tool)new RPCLoadGen(), (String[])args);
        System.exit(res);
    }

    public static class RPCSleepProcessor
    extends SimpleProcessor {
        private final int sleepTimeMax = this.getContext().getUserPayload().getPayload().getInt(0);
        private final byte modeByte = this.getContext().getUserPayload().getPayload().get(4);

        public RPCSleepProcessor(ProcessorContext context) {
            super(context);
        }

        public void run() throws Exception {
            StopWatch sw = new StopWatch().start();
            long sleepTime = random.nextInt(this.sleepTimeMax);
            if (this.modeByte == 0) {
                LOG.info("Received via RPC.");
            } else if (this.modeByte == 1) {
                LOG.info("Reading from local filesystem");
                LocalFileSystem localFs = FileSystem.getLocal((Configuration)new Configuration());
                FSDataInputStream is = localFs.open(new Path(DISK_PAYLOAD_NAME));
                IOUtils.toByteArray((InputStream)is);
            } else if (this.modeByte == 2) {
                LOG.info("Reading from HDFS");
                FileSystem fs = FileSystem.get((Configuration)new Configuration());
                FSDataInputStream is = fs.open(new Path("/tmp", DISK_PAYLOAD_NAME));
                IOUtils.toByteArray((InputStream)is);
            } else {
                throw new IllegalArgumentException("Unknown execution mode: [" + this.modeByte + "]");
            }
            LOG.info("TimeTakenToAccessPayload=" + sw.stop().now(TimeUnit.MILLISECONDS));
            LOG.info("Sleeping for: " + sleepTime);
            Thread.sleep(sleepTime);
        }
    }
}

