/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.library.input;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.tez.dag.api.TezUncheckedException;
import org.apache.tez.runtime.api.Input;
import org.apache.tez.runtime.api.MergedInputContext;
import org.apache.tez.runtime.api.MergedLogicalInput;
import org.apache.tez.runtime.api.ProgressFailedException;
import org.apache.tez.runtime.api.Reader;
import org.apache.tez.runtime.library.api.KeyValueReader;

@InterfaceAudience.Public
public class ConcatenatedMergedKeyValueInput
extends MergedLogicalInput {
    private ConcatenatedMergedKeyValueReader concatenatedMergedKeyValueReader;

    public ConcatenatedMergedKeyValueInput(MergedInputContext context, List<Input> inputs) {
        super(context, inputs);
    }

    public KeyValueReader getReader() throws Exception {
        this.concatenatedMergedKeyValueReader = new ConcatenatedMergedKeyValueReader();
        return this.concatenatedMergedKeyValueReader;
    }

    public void setConstituentInputIsReady(Input input) {
        this.informInputReady();
    }

    public float getProgress() throws ProgressFailedException, InterruptedException {
        try {
            return this.concatenatedMergedKeyValueReader.getProgress();
        }
        catch (IOException e) {
            throw new ProgressFailedException("getProgress encountered IOException ", (Throwable)e);
        }
    }

    public class ConcatenatedMergedKeyValueReader
    extends KeyValueReader {
        private int currentReaderIndex = 0;
        private KeyValueReader currentReader;

        @Override
        public boolean next() throws IOException {
            while (this.currentReader == null || !this.currentReader.next()) {
                if (this.currentReaderIndex == ConcatenatedMergedKeyValueInput.this.getInputs().size()) {
                    this.hasCompletedProcessing();
                    this.completedProcessing = true;
                    ConcatenatedMergedKeyValueInput.this.getContext().notifyProgress();
                    return false;
                }
                try {
                    Reader reader = ((Input)ConcatenatedMergedKeyValueInput.this.getInputs().get(this.currentReaderIndex)).getReader();
                    if (!(reader instanceof KeyValueReader)) {
                        throw new TezUncheckedException("Expected KeyValueReader. Got: " + reader.getClass().getName());
                    }
                    this.currentReader = (KeyValueReader)reader;
                    ++this.currentReaderIndex;
                    ConcatenatedMergedKeyValueInput.this.getContext().notifyProgress();
                }
                catch (Exception e) {
                    if (e instanceof IOException) {
                        throw (IOException)e;
                    }
                    throw new IOException(e);
                }
            }
            return true;
        }

        @Override
        public Object getCurrentKey() throws IOException {
            return this.currentReader.getCurrentKey();
        }

        @Override
        public Object getCurrentValue() throws IOException {
            return this.currentReader.getCurrentValue();
        }

        public float getProgress() throws IOException, InterruptedException {
            return 1.0f * (float)(this.currentReaderIndex + 1) / (float)ConcatenatedMergedKeyValueInput.this.getInputs().size();
        }
    }
}

