/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.tika.exception.TikaException;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.exception.DataElementParseErrorException;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.DataElementData;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.StreamObject;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.StreamObjectTypeHeaderStart;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.basic.BasicObject;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.basic.Compact64bitInt;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.basic.DataElementType;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.basic.ExGuid;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.basic.SerialNumber;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.util.SequenceNumberGenerator;

public class DataElement
extends StreamObject {
    private static final Map<DataElementType, Class> DATA_ELEMENT_DATA_TYPE_MAPPING = new HashMap<DataElementType, Class>();
    public ExGuid dataElementExGuid;
    public SerialNumber serialNumber;
    public DataElementType dataElementType;
    public DataElementData data;

    public DataElement(DataElementType type, DataElementData data) {
        super(StreamObjectTypeHeaderStart.DataElement);
        if (!DATA_ELEMENT_DATA_TYPE_MAPPING.containsKey((Object)type)) {
            throw new IllegalArgumentException("Invalid argument type value" + type.getIntVal());
        }
        this.dataElementType = type;
        this.data = data;
        this.dataElementExGuid = new ExGuid(SequenceNumberGenerator.GetCurrentSerialNumber(), UUID.randomUUID());
        this.serialNumber = new SerialNumber(UUID.randomUUID(), SequenceNumberGenerator.GetCurrentSerialNumber());
    }

    public DataElement() {
        super(StreamObjectTypeHeaderStart.DataElement);
    }

    public <T extends DataElementData> T getData(Class<T> clazz) throws TikaException {
        if (this.data.getClass().equals(clazz)) {
            return (T)this.data;
        }
        throw new TikaException(String.format(Locale.US, "Unable to cast DataElementData to the type %s, its actual type is %s", clazz.getName(), this.data.getClass().getName()));
    }

    @Override
    protected void deserializeItemsFromByteArray(byte[] byteArray, AtomicInteger currentIndex, int lengthOfItems) throws TikaException {
        AtomicInteger index = new AtomicInteger(currentIndex.get());
        try {
            this.dataElementExGuid = BasicObject.parse(byteArray, index, ExGuid.class);
            this.serialNumber = BasicObject.parse(byteArray, index, SerialNumber.class);
            this.dataElementType = DataElementType.fromIntVal((int)BasicObject.parse(byteArray, index, Compact64bitInt.class).getDecodedValue());
        }
        catch (Exception e) {
            throw new DataElementParseErrorException(index.get(), e);
        }
        if (index.get() - currentIndex.get() != lengthOfItems) {
            throw new DataElementParseErrorException(currentIndex.get(), "Failed to check the data element header length, whose value does not cover the dataElementExGUID, SerialNumber and DataElementType", null);
        }
        if (DATA_ELEMENT_DATA_TYPE_MAPPING.containsKey((Object)this.dataElementType)) {
            try {
                this.data = (DataElementData)DATA_ELEMENT_DATA_TYPE_MAPPING.get((Object)this.dataElementType).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new TikaException("Could not instantiate a " + this.dataElementType, e);
            }
            try {
                index.addAndGet(this.data.deserializeDataElementDataFromByteArray(byteArray, index.get()));
            }
            catch (Exception e) {
                throw new DataElementParseErrorException(index.get(), e);
            }
        }
        throw new DataElementParseErrorException(index.get(), "Failed to create specific data element instance with the type " + this.dataElementType, null);
        currentIndex.set(index.get());
    }

    @Override
    protected int serializeItemsToByteList(List<Byte> byteList) throws IOException, TikaException {
        int startIndex = byteList.size();
        byteList.addAll(this.dataElementExGuid.serializeToByteList());
        byteList.addAll(this.serialNumber.serializeToByteList());
        byteList.addAll(new Compact64bitInt(this.dataElementType.getIntVal()).serializeToByteList());
        int headerLength = byteList.size() - startIndex;
        byteList.addAll(this.data.serializeToByteList());
        return headerLength;
    }

    static {
        for (DataElementType value : DataElementType.values()) {
            String className = DataElement.class.getPackage().getName() + "." + value.name();
            try {
                DATA_ELEMENT_DATA_TYPE_MAPPING.put(value, Class.forName(className));
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
    }
}

