/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.renderer.pdf.pdfbox;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.pdfbox.Loader;
import org.apache.pdfbox.io.RandomAccessReadBuffer;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.rendering.ImageType;
import org.apache.pdfbox.rendering.PDFRenderer;
import org.apache.pdfbox.tools.imageio.ImageIOUtil;
import org.apache.tika.config.Initializable;
import org.apache.tika.config.InitializableProblemHandler;
import org.apache.tika.config.Param;
import org.apache.tika.exception.TikaConfigException;
import org.apache.tika.exception.TikaException;
import org.apache.tika.extractor.EmbeddedDocumentUtil;
import org.apache.tika.io.TemporaryResources;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.Property;
import org.apache.tika.metadata.Rendering;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.metadata.TikaPagedText;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.pdf.PDFParser;
import org.apache.tika.parser.pdf.PDFParserConfig;
import org.apache.tika.renderer.PageBasedRenderResults;
import org.apache.tika.renderer.PageRangeRequest;
import org.apache.tika.renderer.RenderRequest;
import org.apache.tika.renderer.RenderResult;
import org.apache.tika.renderer.RenderResults;
import org.apache.tika.renderer.RenderingTracker;
import org.apache.tika.renderer.pdf.pdfbox.PDDocumentRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PDFBoxRenderer
implements PDDocumentRenderer,
Initializable {
    Set<MediaType> SUPPORTED_TYPES = Collections.singleton(PDFParser.MEDIA_TYPE);
    protected static final Logger LOG = LoggerFactory.getLogger(PDFBoxRenderer.class);
    public static Property PDFBOX_RENDERING_TIME_MS = Property.externalReal("rendering:pdfbox-rendering-ms");
    public static Property PDFBOX_IMAGE_WRITING_TIME_MS = Property.externalReal("rendering:pdfbox-image-writing-ms");
    private int defaultDPI = 300;
    private ImageType defaultImageType = ImageType.GRAY;
    private String defaultImageFormatName = "png";

    @Override
    public Set<MediaType> getSupportedTypes(ParseContext context) {
        return this.SUPPORTED_TYPES;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RenderResults render(InputStream is, Metadata metadata, ParseContext parseContext, RenderRequest ... requests) throws IOException, TikaException {
        PDDocument pdDocument;
        TikaInputStream tis = TikaInputStream.get(is);
        boolean mustClose = false;
        if (tis.getOpenContainer() != null) {
            pdDocument = (PDDocument)tis.getOpenContainer();
        } else {
            pdDocument = Loader.loadPDF(new RandomAccessReadBuffer(is));
            mustClose = true;
        }
        PageBasedRenderResults results = new PageBasedRenderResults(new TemporaryResources());
        try {
            for (RenderRequest renderRequest : requests) {
                this.processRequest(renderRequest, pdDocument, metadata, parseContext, results);
            }
        }
        finally {
            if (mustClose) {
                pdDocument.close();
            }
        }
        return results;
    }

    private void processRequest(RenderRequest renderRequest, PDDocument pdDocument, Metadata metadata, ParseContext parseContext, PageBasedRenderResults results) {
        if (renderRequest == PageRangeRequest.RENDER_ALL || renderRequest.equals(PageRangeRequest.RENDER_ALL)) {
            this.renderRange(pdDocument, 1, pdDocument.getNumberOfPages(), metadata, parseContext, results);
        } else if (renderRequest instanceof PageRangeRequest) {
            int start = ((PageRangeRequest)renderRequest).getFrom();
            int toInclusive = ((PageRangeRequest)renderRequest).getTo();
            this.renderRange(pdDocument, start, toInclusive, metadata, parseContext, results);
        }
    }

    private void renderRange(PDDocument pdDocument, int start, int endInclusive, Metadata metadata, ParseContext parseContext, PageBasedRenderResults results) {
        PDFRenderer renderer = new PDFRenderer(pdDocument);
        RenderingTracker tracker = parseContext.get(RenderingTracker.class);
        if (tracker == null) {
            tracker = new RenderingTracker();
            parseContext.set(RenderingTracker.class, tracker);
        }
        for (int i = start; i <= endInclusive; ++i) {
            int id = tracker.getNextId();
            Metadata m = new Metadata();
            m.set(TikaCoreProperties.EMBEDDED_RESOURCE_TYPE, TikaCoreProperties.EmbeddedResourceType.RENDERING.name());
            try {
                m.set(TikaPagedText.PAGE_NUMBER, i);
                m.set(TikaPagedText.PAGE_ROTATION, (double)pdDocument.getPage(i - 1).getRotation());
                results.add(this.renderPage(renderer, id, i, m, parseContext));
                continue;
            }
            catch (IOException e) {
                EmbeddedDocumentUtil.recordException(e, m);
                results.add(new RenderResult(RenderResult.STATUS.EXCEPTION, id, null, m));
            }
        }
    }

    protected RenderResult renderPage(PDFRenderer renderer, int id, int pageNumber, Metadata metadata, ParseContext parseContext) throws IOException {
        Path tmpFile = Files.createTempFile("tika-pdfbox-rendering-", "-" + id + "-" + pageNumber + "." + this.getImageFormatName(parseContext), new FileAttribute[0]);
        try {
            long start = System.currentTimeMillis();
            BufferedImage image = renderer.renderImageWithDPI(pageNumber - 1, this.getDPI(parseContext), this.getImageType(parseContext));
            long renderingElapsed = System.currentTimeMillis() - start;
            metadata.set(PDFBOX_RENDERING_TIME_MS, renderingElapsed);
            start = System.currentTimeMillis();
            try (OutputStream os = Files.newOutputStream(tmpFile, new OpenOption[0]);){
                ImageIOUtil.writeImage(image, this.getImageFormatName(parseContext), os, this.getDPI(parseContext));
            }
            long elapsedWrite = System.currentTimeMillis() - start;
            metadata.set(PDFBOX_IMAGE_WRITING_TIME_MS, elapsedWrite);
            metadata.set(Rendering.RENDERED_MS, renderingElapsed + elapsedWrite);
        }
        catch (SecurityException e) {
            throw e;
        }
        catch (Exception e) {
            try {
                Files.delete(tmpFile);
            }
            catch (IOException ex) {
                LOG.warn("couldn't delete " + tmpFile, ex);
            }
            throw new IOException(e);
        }
        return new RenderResult(RenderResult.STATUS.SUCCESS, id, tmpFile, metadata);
    }

    @Override
    public void initialize(Map<String, Param> params) throws TikaConfigException {
    }

    @Override
    public void checkInitialization(InitializableProblemHandler problemHandler) throws TikaConfigException {
    }

    public void setDPI(int dpi) {
        this.defaultDPI = dpi;
    }

    public void setImageType(ImageType imageType) {
        this.defaultImageType = imageType;
    }

    public void setImageFormatName(String imageFormatName) {
        this.defaultImageFormatName = imageFormatName;
    }

    protected int getDPI(ParseContext parseContext) {
        PDFParserConfig pdfParserConfig = parseContext.get(PDFParserConfig.class);
        if (pdfParserConfig == null) {
            return this.defaultDPI;
        }
        return pdfParserConfig.getOcrDPI();
    }

    protected ImageType getImageType(ParseContext parseContext) {
        PDFParserConfig pdfParserConfig = parseContext.get(PDFParserConfig.class);
        if (pdfParserConfig == null) {
            return this.defaultImageType;
        }
        return pdfParserConfig.getOcrImageType().getImageType();
    }

    protected String getImageFormatName(ParseContext parseContext) {
        PDFParserConfig pdfParserConfig = parseContext.get(PDFParserConfig.class);
        if (pdfParserConfig == null) {
            return this.defaultImageFormatName;
        }
        return pdfParserConfig.getOcrImageFormatName();
    }
}

